/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.jasper.compiler.Localizer;

public class JspWriterImpl
extends JspWriter {
    private Writer out;
    private ServletResponse response;
    private char[] cb;
    private int nextChar;
    private boolean flushed = false;
    private boolean closed = false;

    public JspWriterImpl() {
        super(8192, true);
    }

    public JspWriterImpl(ServletResponse servletResponse, int n, boolean bl) {
        super(n, bl);
        if (n < 0) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeBufferSize"));
        }
        this.response = servletResponse;
        this.cb = n == 0 ? null : new char[n];
        this.nextChar = 0;
    }

    void init(ServletResponse servletResponse, int n, boolean bl) {
        this.response = servletResponse;
        if (n > 0 && (this.cb == null || n > this.cb.length)) {
            this.cb = new char[n];
        }
        this.nextChar = 0;
        this.autoFlush = bl;
        this.bufferSize = n;
    }

    void recycle() {
        this.flushed = false;
        this.closed = false;
        this.out = null;
        this.nextChar = 0;
        this.response = null;
    }

    protected final void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        this.flushed = true;
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.initOut();
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            try {
                this.out = this.response.getWriter();
            }
            catch (IllegalStateException illegalStateException) {
                this.out = new PrintWriter((OutputStream)this.response.getOutputStream());
            }
        }
    }

    public final void clear() throws IOException {
        if (this.bufferSize == 0 && this.out != null) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.ise_on_clear"));
        }
        if (this.flushed) {
            throw new IOException(Localizer.getMessage("jsp.error.attempt_to_clear_flushed_buffer"));
        }
        this.ensureOpen();
        this.nextChar = 0;
    }

    public void clearBuffer() throws IOException {
        if (this.bufferSize == 0) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.ise_on_clear"));
        }
        this.ensureOpen();
        this.nextChar = 0;
    }

    private void bufferOverflow() throws IOException {
        throw new IOException(Localizer.getMessage("jsp.error.overflow"));
    }

    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        if (this.response == null || this.closed) {
            return;
        }
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.closed = true;
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    private void ensureOpen() throws IOException {
        if (this.response == null || this.closed) {
            throw new IOException(Localizer.getMessage("jsp.error.stream.closed"));
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(n);
        } else {
            if (this.nextChar >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)n;
        }
    }

    private static int min(int n, int n2) {
        return Math.min(n, n2);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(cArray, n, n2);
            return;
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.initOut();
            this.out.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = JspWriterImpl.min(this.bufferSize - this.nextChar, n4 - n3);
            System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(string, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = JspWriterImpl.min(this.bufferSize - this.nextChar, n4 - n3);
            string.getChars(n3, n3 + n5, this.cb, this.nextChar);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    public void newLine() throws IOException {
        this.write(System.lineSeparator());
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int n) throws IOException {
        this.write(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) throws IOException {
        this.write(cArray);
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) throws IOException {
        this.write(String.valueOf(object));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.println();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.println();
    }
}

