/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jgrapht.DirectedGraph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.ModifiableInteger;

public class TopologicalOrderIterator<V, E>
extends CrossComponentIterator<V, E, Object> {
    private Queue<V> queue;
    private Map<V, ModifiableInteger> inDegreeMap;

    public TopologicalOrderIterator(DirectedGraph<V, E> dg) {
        this(dg, (V)new LinkedListQueue());
    }

    public TopologicalOrderIterator(DirectedGraph<V, E> dg, Queue<V> queue) {
        this(dg, queue, new HashMap());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> dg, Queue<V> queue, Map<V, ModifiableInteger> inDegreeMap) {
        this(dg, TopologicalOrderIterator.initialize(dg, queue, inDegreeMap));
        this.queue = queue;
        this.inDegreeMap = inDegreeMap;
        assert (dg.vertexSet().isEmpty() || !queue.isEmpty());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> dg, V start) {
        super(dg, start);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        return this.queue.isEmpty();
    }

    @Override
    protected void encounterVertex(V vertex, E edge) {
        this.putSeenData(vertex, null);
        this.decrementInDegree(vertex);
    }

    @Override
    protected void encounterVertexAgain(V vertex, E edge) {
        this.decrementInDegree(vertex);
    }

    @Override
    protected V provideNextVertex() {
        return this.queue.remove();
    }

    private void decrementInDegree(V vertex) {
        ModifiableInteger inDegree = this.inDegreeMap.get(vertex);
        if (inDegree.value > 0) {
            --inDegree.value;
            if (inDegree.value == 0) {
                this.queue.offer(vertex);
            }
        }
    }

    private static <V, E> V initialize(DirectedGraph<V, E> dg, Queue<V> queue, Map<V, ModifiableInteger> inDegreeMap) {
        for (Object vertex : dg.vertexSet()) {
            int inDegree = dg.inDegreeOf(vertex);
            inDegreeMap.put((ModifiableInteger)vertex, new ModifiableInteger(inDegree));
            if (inDegree != 0) continue;
            queue.offer(vertex);
        }
        if (queue.isEmpty()) {
            return null;
        }
        return queue.peek();
    }

    private static class LinkedListQueue<T>
    extends LinkedList<T>
    implements Queue<T> {
        private static final long serialVersionUID = 4217659843476891334L;

        private LinkedListQueue() {
        }

        @Override
        public T element() {
            return (T)this.getFirst();
        }

        @Override
        public boolean offer(T o) {
            return this.add(o);
        }

        @Override
        public T peek() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.getFirst();
        }

        @Override
        public T poll() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.removeFirst();
        }

        @Override
        public T remove() {
            return (T)this.removeFirst();
        }
    }
}

