﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2_EXPORTS.h>
#include <aws/kinesisanalyticsv2/model/VpcConfigurationDescription.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace KinesisAnalyticsV2 {
namespace Model {
class AddApplicationVpcConfigurationResult {
 public:
  AWS_KINESISANALYTICSV2_API AddApplicationVpcConfigurationResult() = default;
  AWS_KINESISANALYTICSV2_API AddApplicationVpcConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KINESISANALYTICSV2_API AddApplicationVpcConfigurationResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the application.</p>
   */
  inline const Aws::String& GetApplicationARN() const { return m_applicationARN; }
  template <typename ApplicationARNT = Aws::String>
  void SetApplicationARN(ApplicationARNT&& value) {
    m_applicationARNHasBeenSet = true;
    m_applicationARN = std::forward<ApplicationARNT>(value);
  }
  template <typename ApplicationARNT = Aws::String>
  AddApplicationVpcConfigurationResult& WithApplicationARN(ApplicationARNT&& value) {
    SetApplicationARN(std::forward<ApplicationARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provides the current application version. Managed Service for Apache Flink
   * updates the ApplicationVersionId each time you update the application.</p>
   */
  inline long long GetApplicationVersionId() const { return m_applicationVersionId; }
  inline void SetApplicationVersionId(long long value) {
    m_applicationVersionIdHasBeenSet = true;
    m_applicationVersionId = value;
  }
  inline AddApplicationVpcConfigurationResult& WithApplicationVersionId(long long value) {
    SetApplicationVersionId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The parameters of the new VPC configuration.</p>
   */
  inline const VpcConfigurationDescription& GetVpcConfigurationDescription() const { return m_vpcConfigurationDescription; }
  template <typename VpcConfigurationDescriptionT = VpcConfigurationDescription>
  void SetVpcConfigurationDescription(VpcConfigurationDescriptionT&& value) {
    m_vpcConfigurationDescriptionHasBeenSet = true;
    m_vpcConfigurationDescription = std::forward<VpcConfigurationDescriptionT>(value);
  }
  template <typename VpcConfigurationDescriptionT = VpcConfigurationDescription>
  AddApplicationVpcConfigurationResult& WithVpcConfigurationDescription(VpcConfigurationDescriptionT&& value) {
    SetVpcConfigurationDescription(std::forward<VpcConfigurationDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The operation ID that can be used to track the request.</p>
   */
  inline const Aws::String& GetOperationId() const { return m_operationId; }
  template <typename OperationIdT = Aws::String>
  void SetOperationId(OperationIdT&& value) {
    m_operationIdHasBeenSet = true;
    m_operationId = std::forward<OperationIdT>(value);
  }
  template <typename OperationIdT = Aws::String>
  AddApplicationVpcConfigurationResult& WithOperationId(OperationIdT&& value) {
    SetOperationId(std::forward<OperationIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AddApplicationVpcConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationARN;
  bool m_applicationARNHasBeenSet = false;

  long long m_applicationVersionId{0};
  bool m_applicationVersionIdHasBeenSet = false;

  VpcConfigurationDescription m_vpcConfigurationDescription;
  bool m_vpcConfigurationDescriptionHasBeenSet = false;

  Aws::String m_operationId;
  bool m_operationIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace KinesisAnalyticsV2
}  // namespace Aws
