/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.logging;

import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.AbstractLogger;

public class DefaultLogger
extends AbstractLogger {
    private final ResolverConfiguration config;
    private int logLevel;
    private String defaultLoggerLevel;
    private String currentLoggingLevel;

    public DefaultLogger(ResolverConfiguration config) {
        this.config = config;
        this.setLogLevel(config.getFeature(ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL));
        this.defaultLoggerLevel = this.currentLoggingLevel;
    }

    public String getLogLevel() {
        this.checkLoggingLevel();
        switch (this.logLevel) {
            case 2: {
                return "info";
            }
            case 1: {
                return "debug";
            }
            case 3: {
                return "warn";
            }
            case 4: {
                return "none";
            }
        }
        return "unknown";
    }

    public void setLogLevel(String level) {
        this.currentLoggingLevel = level;
        switch (level) {
            case "info": {
                this.logLevel = 2;
                break;
            }
            case "debug": {
                this.logLevel = 1;
                break;
            }
            case "warn": {
                this.logLevel = 3;
                break;
            }
            case "none": {
                this.logLevel = 4;
                break;
            }
            default: {
                System.err.println("Invalid default logger log level: " + level);
                this.logLevel = 3;
                this.currentLoggingLevel = "warn";
            }
        }
    }

    private void checkLoggingLevel() {
        String currentLevel = this.config.getFeature(ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL);
        if (currentLevel != null && !currentLevel.equals(this.defaultLoggerLevel)) {
            this.setLogLevel(currentLevel);
            this.defaultLoggerLevel = this.currentLoggingLevel;
        }
    }

    @Override
    public void info(String message) {
        this.checkLoggingLevel();
        if (this.logLevel <= 2) {
            System.err.println(message);
        }
    }

    @Override
    public void debug(String message) {
        this.checkLoggingLevel();
        if (this.logLevel <= 1) {
            System.err.println(message);
        }
    }

    @Override
    public void warn(String message) {
        this.checkLoggingLevel();
        if (this.logLevel <= 3) {
            System.err.println(message);
        }
    }
}

