/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.EnumValueSnapshot;
import org.jspecify.annotations.Nullable;

public class IsolatedEnumValueSnapshot
extends EnumValueSnapshot
implements Isolatable<Enum<?>> {
    private final Enum<?> value;

    public IsolatedEnumValueSnapshot(Enum<?> value) {
        super(value);
        this.value = value;
    }

    public Enum<?> getValue() {
        return this.value;
    }

    public ValueSnapshot asSnapshot() {
        return new EnumValueSnapshot(this.value);
    }

    public Enum<?> isolate() {
        return this.value;
    }

    public <S> @Nullable S coerce(Class<S> type) {
        if (type.isInstance(this.value)) {
            return type.cast(this.value);
        }
        if (type.isEnum() && type.getName().equals(this.value.getDeclaringClass().getName())) {
            return type.cast(Enum.valueOf((Class)Cast.uncheckedNonnullCast(type.asSubclass(Enum.class)), this.value.name()));
        }
        return null;
    }
}

