/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class ContractionSpellingRule
extends AbstractSimpleReplaceRule {
    public static final String CONTRACTION_SPELLING_RULE = "EN_CONTRACTION_SPELLING";
    private static final Map<String, List<String>> wrongWords = ContractionSpellingRule.loadFromPath((String)"/en/contractions.txt");
    private static final Locale EN_LOCALE = new Locale("en");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public ContractionSpellingRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"We <marker>havent</marker> earned anything."), Example.fixed((String)"We <marker>haven't</marker> earned anything."));
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/post/grammar-contractions/"));
        super.setCheckLemmas(false);
    }

    public final String getId() {
        return CONTRACTION_SPELLING_RULE;
    }

    public String getDescription() {
        return "Spelling of English contractions";
    }

    public String getShort() {
        return "Spelling mistake";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Possible spelling mistake found.";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return EN_LOCALE;
    }
}

