/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import java.security.Key;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.keybinding.ProofValidator;

public abstract class AbstractProofValidator
implements ProofValidator {
    protected final KeycloakSession keycloakSession;

    protected AbstractProofValidator(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    protected SignatureVerifierContext getVerifier(JWK jwk, String jwsAlgorithm) throws VerificationException {
        SignatureProvider signatureProvider = (SignatureProvider)this.keycloakSession.getProvider(SignatureProvider.class, jwsAlgorithm);
        KeyWrapper keyWrapper = this.getKeyWrapper(jwk, jwsAlgorithm);
        keyWrapper.setUse(KeyUse.SIG);
        return signatureProvider.verifier(keyWrapper);
    }

    private KeyWrapper getKeyWrapper(JWK jwk, String algorithm) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setType(jwk.getKeyType());
        keyWrapper.setAlgorithm(algorithm);
        if (jwk.getOtherClaims().get("crv") != null) {
            keyWrapper.setCurve((String)jwk.getOtherClaims().get("crv"));
        }
        JWKParser parser = JWKParser.create((JWK)jwk);
        keyWrapper.setPublicKey((Key)parser.toPublicKey());
        return keyWrapper;
    }
}

