/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

public class StatementOptions {
    public static final StatementOptions NONE = new StatementOptions(-1, -1, -1, -1);
    private final Integer firstRow;
    private final Integer maxRows;
    private final Integer timeoutInMilliseconds;
    private final Integer fetchSize;

    public StatementOptions(Integer firstRow, Integer maxRows, Integer timeoutInMilliseconds, Integer fetchSize) {
        this.firstRow = firstRow;
        this.maxRows = maxRows;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.fetchSize = fetchSize;
    }

    public boolean hasLimit() {
        return this.firstRow != null && this.firstRow > 0 || this.maxRows != null && this.maxRows > 0;
    }

    public Integer getFirstRow() {
        return this.firstRow;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public boolean hasTimeout() {
        return this.timeoutInMilliseconds != null && this.timeoutInMilliseconds > 0;
    }

    public Integer getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public boolean hasFetchSize() {
        return this.fetchSize != null && this.fetchSize > 0;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }
}

