/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language.identifier.detector;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.language.identifier.detector.FastTextDetector;

public class FastTextTest {
    private static final File MODEL_PATH = new File("/prg/fastText-0.1.0/data/lid.176.bin");
    private static final File BINARY_PATH = new File("/prg/fastText-0.1.0/fasttext");

    @Test
    @Ignore(value="for interactive use")
    public void testInteractively() throws Exception {
        FastTextDetector ft = new FastTextDetector(MODEL_PATH, BINARY_PATH);
        List<String> langCodes = Arrays.asList("en", "de", "fr", "es");
        String s = "PROJECT TAGGING CRITERIA";
        Map res1 = ft.runFasttext(s, langCodes);
        System.out.println(res1);
    }

    @Test
    @Ignore(value="requires local FastText")
    public void testCaseShouldNotMatter() throws Exception {
        FastTextDetector ft = new FastTextDetector(MODEL_PATH, BINARY_PATH);
        List<String> langCodes = Arrays.asList("en", "de", "fr", "es", "ko");
        String s = "project tagging criteria";
        Map res1 = ft.runFasttext(s, langCodes);
        Map res2 = ft.runFasttext(s.toUpperCase(Locale.ROOT), langCodes);
        Assert.assertEquals((Object)res1, (Object)res2);
    }

    @Test
    @Ignore(value="for interactive use")
    public void testEverShorterTextWithFastText() throws IOException {
        FastTextDetector ft = new FastTextDetector(new File("/prg/fastText-0.9.2/lid.176.bin"), new File("/prg/fastText-0.9.2/fasttext"));
        List<String> langs = Arrays.asList("en", "de", "fr", "es", "nl");
        List<String> lines = Files.readAllLines(Paths.get("/home/dnaber/lt/lang-detect-test-en-25K.txt", new String[0]));
        String expected = "en";
        System.out.println("Loaded " + lines.size() + " lines");
        long startTime = System.currentTimeMillis();
        int lineCount = 0;
        long thresholdLengthsSum = 0L;
        block0: for (String line : lines) {
            ++lineCount;
            for (int i = line.length(); i > 0; --i) {
                String shortened = line.substring(0, i);
                Map resMap = ft.runFasttext(shortened, langs);
                String bestLang = this.getBestLang(resMap);
                if (expected.equals(bestLang)) continue;
                System.out.println(lineCount + ". " + bestLang + " " + shortened + " @" + shortened.length());
                thresholdLengthsSum += (long)shortened.length();
                continue block0;
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("runtime: " + (endTime - startTime) + "ms");
        float avg = (float)thresholdLengthsSum / (float)lineCount;
        System.out.printf(Locale.ENGLISH, "avg. first detection failure: %.2f%n", Float.valueOf(avg));
    }

    @Nullable
    private String getBestLang(Map<String, Double> resMap) {
        String bestLang = null;
        double baseValSoFar = 0.0;
        for (Map.Entry<String, Double> entry : resMap.entrySet()) {
            if (!(entry.getValue() > baseValSoFar)) continue;
            bestLang = entry.getKey();
            baseValSoFar = entry.getValue();
        }
        return bestLang;
    }

    @Test
    public void testParsing() throws Exception {
        FastTextDetector ft = new FastTextDetector();
        List<String> l = Arrays.asList("en", "fy", "de", "es", "nl");
        Map res1 = ft.parseBuffer("__label__nl 0.423696 __label__fy 0.207109\n", l);
        MatcherAssert.assertThat((Object)res1.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((Double)res1.get("nl")), (Matcher)Is.is((Object)0.423696));
        MatcherAssert.assertThat((Object)((Double)res1.get("fy")), (Matcher)Is.is((Object)0.207109));
        Map res2 = ft.parseBuffer("__label__de 0.999985 __label__es 2.02195e-05", l);
        MatcherAssert.assertThat((Object)res2.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((Double)res2.get("de")), (Matcher)Is.is((Object)0.999985));
        MatcherAssert.assertThat((Object)((Double)res2.get("es")), (Matcher)Is.is((Object)2.02195E-5));
        Map res3 = ft.parseBuffer("__label__en 1", l);
        MatcherAssert.assertThat((Object)res3.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((Double)res3.get("en")), (Matcher)Is.is((Object)1.0));
        Map res4 = ft.parseBuffer("__label__de 1.00003", l);
        MatcherAssert.assertThat((Object)res4.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((Double)res4.get("de")), (Matcher)Is.is((Object)1.00003));
        try {
            ft.parseBuffer("xxx", l);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            ft.parseBuffer("xxx foo", l);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        System.out.println("Ignore the following WARN:");
        Map res5 = ft.parseBuffer("__label__de 0.9\n__label__fr 0.1", l);
        MatcherAssert.assertThat((Object)res5.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((Double)res5.get("de")), (Matcher)Is.is((Object)0.9));
    }
}

