/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import java.util.List;
import java.util.stream.Stream;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.FinalStageFilterFactory;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.models.TModelFilm;
import org.jetbrains.annotations.NotNull;

public class GuiFilmeModelHelper
extends GuiModelHelper {
    private TModelFilm filmModel;

    public GuiFilmeModelHelper(@NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData, @NotNull FilterConfiguration filterConfiguration) {
        super(historyController, searchFieldData, filterConfiguration);
    }

    private void performTableFiltering() {
        boolean searchFieldEmpty;
        this.calculateFilmLengthSliderValues();
        if (this.filterConfiguration.isShowUnseenOnly()) {
            this.historyController.prepareMemoryCache();
        }
        Stream<Object> stream = Daten.getInstance().getListeFilmeNachBlackList().parallelStream();
        List<String> selectedSenders = this.getSelectedSendersFromFilter();
        if (!selectedSenders.isEmpty()) {
            stream = stream.filter(f -> selectedSenders.contains(f.getSender()));
        }
        if (this.filterConfiguration.isShowNewOnly()) {
            stream = stream.filter(DatenFilm::isNew);
        }
        if (this.filterConfiguration.isShowBookMarkedOnly()) {
            stream = stream.filter(DatenFilm::isBookmarked);
        }
        if (this.filterConfiguration.isShowLivestreamsOnly()) {
            stream = stream.filter(DatenFilm::isLivestream);
        }
        if (this.filterConfiguration.isShowHighQualityOnly()) {
            stream = stream.filter(DatenFilm::isHighQuality);
        }
        if (this.filterConfiguration.isDontShowTrailers()) {
            stream = stream.filter(film -> !film.isTrailerTeaser());
        }
        if (this.filterConfiguration.isDontShowSignLanguage()) {
            stream = stream.filter(film -> !film.isSignLanguage());
        }
        if (this.filterConfiguration.isDontShowAudioVersions()) {
            stream = stream.filter(film -> !film.isAudioVersion());
        }
        if (this.filterConfiguration.isDontShowAbos()) {
            stream = stream.filter(film -> film.getAbo() == null);
        }
        if (this.filterConfiguration.isDontShowDuplicates()) {
            stream = stream.filter(film -> !film.isDuplicate());
        }
        if (this.filterConfiguration.isShowSubtitlesOnly()) {
            stream = stream.filter(DatenFilm::hasAnySubtitles);
        }
        stream = this.applyCommonFilters(stream, this.filterConfiguration.getThema());
        String[] arrIrgendwo = this.searchFieldData.evaluateThemaTitel();
        boolean bl = searchFieldEmpty = arrIrgendwo.length == 0;
        if (!searchFieldEmpty) {
            stream = stream.filter(FinalStageFilterFactory.createFinalStageFilter(this.searchFieldData.searchThroughDescriptions(), arrIrgendwo));
        }
        List<Object> list = stream.toList();
        stream.close();
        this.filmModel = new TModelFilm(list.size());
        this.filmModel.addAll(list);
        if (this.filterConfiguration.isShowUnseenOnly()) {
            this.historyController.emptyMemoryCache();
        }
    }

    @Override
    public TableModel getFilteredTableModel() {
        ListeFilme listeFilme = Daten.getInstance().getListeFilmeNachBlackList();
        if (!listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                this.filmModel = new TModelFilm(listeFilme.size());
                this.filmModel.addAll(listeFilme);
            } else {
                this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return this.filmModel;
    }
}

