/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.jdk;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdkSpecificClass {
    private static Map<String, Boolean> _synthIconMap;

    public static boolean isSynthIconClassName(String name) {
        return name != null && name.contains("sun.swing.plaf.synth.SynthIcon");
    }

    public static boolean isSynthIcon(Icon icon) {
        if (_synthIconMap == null) {
            _synthIconMap = new HashMap<String, Boolean>();
        }
        ArrayList<String> classNamesToPut = new ArrayList<String>();
        boolean isSynthIcon = false;
        for (Class<?> aClass = icon.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.getCanonicalName();
            if (name == null) continue;
            Boolean value = _synthIconMap.get(name);
            if (value != null) {
                return value;
            }
            classNamesToPut.add(name);
            if (!JdkSpecificClass.isSynthIconClassName(name)) continue;
            isSynthIcon = true;
            break;
        }
        for (String name : classNamesToPut) {
            _synthIconMap.put(name, isSynthIcon);
        }
        return isSynthIcon;
    }

    public static void paintCheckBoxIcon(JComponent c, Icon icon, Graphics g, int state, int x, int y) {
        SynthContext context = new SynthContext(c, Region.CHECK_BOX, SynthLookAndFeel.getStyle(c, Region.CHECK_BOX), state);
        int w = ((SynthIcon)icon).getIconWidth(context);
        int h = ((SynthIcon)icon).getIconHeight(context);
        ((SynthIcon)icon).paintIcon(context, g, x, y, w, h);
    }

    public static void paintTableHeaderIcon(JComponent c, Icon icon, Graphics g, int x, int y) {
        SynthContext context = new SynthContext(c, Region.TABLE_HEADER, SynthLookAndFeel.getStyle(c, Region.TABLE_HEADER), 0);
        ((SynthIcon)icon).paintIcon(context, g, x, y, ((SynthIcon)icon).getIconWidth(context), ((SynthIcon)icon).getIconHeight(context));
    }

    public static void paintTableCellIcon(JTable table, Icon icon, Graphics g, int iconX, int iconY) {
        SynthContext context = new SynthContext(table, Region.TREE_CELL, SynthLookAndFeel.getStyle(table, Region.TREE_CELL), 0);
        ((SynthIcon)icon).paintIcon(context, g, iconX, iconY, ((SynthIcon)icon).getIconWidth(context), ((SynthIcon)icon).getIconHeight(context));
    }

    public static int[] getVersions() {
        return null;
    }
}

