/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.uritemplate.URITemplateMessageBundle;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.parse.CharMatchers;
import com.github.fge.uritemplate.vars.specs.ExplodedVariable;
import com.github.fge.uritemplate.vars.specs.PrefixVariable;
import com.github.fge.uritemplate.vars.specs.SimpleVariable;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.nio.CharBuffer;
import java.util.ArrayList;

final class VariableSpecParser {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(URITemplateMessageBundle.class);
    private static final Joiner JOINER = Joiner.on('.');
    private static final CharMatcher VARCHAR = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.is('_')).or(CharMatchers.PERCENT).precomputed();
    private static final CharMatcher DOT = CharMatcher.is('.');
    private static final CharMatcher COLON = CharMatcher.is(':');
    private static final CharMatcher STAR = CharMatcher.is('*');
    private static final CharMatcher DIGIT = CharMatcher.inRange('0', '9').precomputed();

    private VariableSpecParser() {
    }

    public static VariableSpec parse(CharBuffer buffer) throws URITemplateParseException {
        String name = VariableSpecParser.parseFullName(buffer);
        if (!buffer.hasRemaining()) {
            return new SimpleVariable(name);
        }
        char c = buffer.charAt(0);
        if (STAR.matches(c)) {
            buffer.get();
            return new ExplodedVariable(name);
        }
        if (COLON.matches(c)) {
            buffer.get();
            return new PrefixVariable(name, VariableSpecParser.getPrefixLength(buffer));
        }
        return new SimpleVariable(name);
    }

    private static String parseFullName(CharBuffer buffer) throws URITemplateParseException {
        ArrayList<String> components = Lists.newArrayList();
        while (true) {
            components.add(VariableSpecParser.readName(buffer));
            if (!buffer.hasRemaining() || !DOT.matches(buffer.charAt(0))) break;
            buffer.get();
        }
        return JOINER.join(components);
    }

    private static String readName(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && VARCHAR.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
            if (!CharMatchers.PERCENT.matches(c)) continue;
            VariableSpecParser.parsePercentEncoded(buffer, sb);
        }
        String ret = sb.toString();
        if (ret.isEmpty()) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.emptyVarname"), buffer);
        }
        return ret;
    }

    private static void parsePercentEncoded(CharBuffer buffer, StringBuilder sb) throws URITemplateParseException {
        if (buffer.remaining() < 2) {
            throw new URITemplateParseException(BUNDLE.getMessage("paser.percentShortRead"), buffer, true);
        }
        char first = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(first)) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.percentIllegal"), buffer, true);
        }
        char second = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(second)) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.percentIllegal"), buffer, true);
        }
        sb.append(first).append(second);
    }

    private static int getPrefixLength(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && DIGIT.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
        }
        String s2 = sb.toString();
        if (s2.isEmpty()) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.emptyPrefix"), buffer, true);
        }
        try {
            int ret = Integer.parseInt(s2);
            if (ret > 10000) {
                throw new NumberFormatException();
            }
            return ret;
        }
        catch (NumberFormatException ignored) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.prefixTooLarge"), buffer, true);
        }
    }
}

