/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFields;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.lucene.index.DerivedSourceStoredFieldsReader;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.opensearch.core.common.bytes.BytesReference;

public class DerivedSourceLeafReader
extends SequentialStoredFieldsLeafReader {
    private final CheckedFunction<Integer, BytesReference, IOException> sourceProvider;

    public DerivedSourceLeafReader(LeafReader in, CheckedFunction<Integer, BytesReference, IOException> sourceProvider) {
        super(in);
        this.sourceProvider = sourceProvider;
    }

    @Override
    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return reader;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public StoredFields storedFields() throws IOException {
        return new DerivedSourceStoredFieldsReader.DerivedSourceStoredFields(this.in.storedFields(), this.sourceProvider);
    }

    @Override
    public StoredFieldsReader getSequentialStoredFieldsReader() throws IOException {
        if (this.in instanceof CodecReader) {
            CodecReader reader = (CodecReader)this.in;
            StoredFieldsReader sequentialReader = reader.getFieldsReader().getMergeInstance();
            return this.doGetSequentialStoredFieldsReader(new DerivedSourceStoredFieldsReader(sequentialReader, this.sourceProvider));
        }
        if (this.in instanceof SequentialStoredFieldsLeafReader) {
            SequentialStoredFieldsLeafReader reader = (SequentialStoredFieldsLeafReader)this.in;
            StoredFieldsReader sequentialReader = reader.getSequentialStoredFieldsReader();
            return this.doGetSequentialStoredFieldsReader(new DerivedSourceStoredFieldsReader(sequentialReader, this.sourceProvider));
        }
        throw new IOException("requires a CodecReader or a SequentialStoredFieldsLeafReader, got " + String.valueOf(this.in.getClass()));
    }
}

