/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.NoOpOffsetStrategy;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.opensearch.index.IndexSettings;
import org.opensearch.lucene.search.uhighlight.CustomFieldHighlighter;
import org.opensearch.lucene.search.uhighlight.Snippet;

public class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    public static final char MULTIVAL_SEP_CHAR = '\u0000';
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final UnifiedHighlighter.OffsetSource offsetSource;
    private final PassageFormatter passageFormatter;
    private final BreakIterator breakIterator;
    private final String index;
    private final String field;
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private final CustomFieldHighlighter fieldHighlighter;
    private final int maxAnalyzedOffset;
    private final Integer fieldMaxAnalyzedOffset;

    public CustomUnifiedHighlighter(UnifiedHighlighter.Builder builder, UnifiedHighlighter.OffsetSource offsetSource, PassageFormatter passageFormatter, @Nullable Locale breakIteratorLocale, @Nullable BreakIterator breakIterator, String index, String field, Query query, int noMatchSize, int maxPassages, int maxAnalyzedOffset, Integer fieldMaxAnalyzedOffset) throws IOException {
        super(builder);
        this.offsetSource = offsetSource;
        this.breakIterator = breakIterator;
        this.breakIteratorLocale = breakIteratorLocale == null ? Locale.ROOT : breakIteratorLocale;
        this.passageFormatter = passageFormatter;
        this.index = index;
        this.field = field;
        this.noMatchSize = noMatchSize;
        this.maxAnalyzedOffset = maxAnalyzedOffset;
        this.fieldHighlighter = (CustomFieldHighlighter)this.getFieldHighlighter(field, query, CustomUnifiedHighlighter.extractTerms((Query)query), maxPassages);
        this.fieldMaxAnalyzedOffset = fieldMaxAnalyzedOffset;
    }

    public Snippet[] highlightField(LeafReader reader, int docId, CheckedSupplier<String, IOException> loadFieldValue) throws IOException {
        if (this.fieldHighlighter.getFieldOffsetStrategy() == NoOpOffsetStrategy.INSTANCE && this.noMatchSize == 0) {
            return EMPTY_SNIPPET;
        }
        String fieldValue = (String)loadFieldValue.get();
        if (fieldValue == null) {
            return null;
        }
        int fieldValueLength = fieldValue.length();
        if (this.fieldMaxAnalyzedOffset != null && this.fieldMaxAnalyzedOffset > this.maxAnalyzedOffset) {
            throw new IllegalArgumentException("max_analyzer_offset has exceeded [" + this.maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!");
        }
        if (this.offsetSource == UnifiedHighlighter.OffsetSource.ANALYSIS && fieldValueLength > this.maxAnalyzedOffset && this.fieldMaxAnalyzedOffset == null) {
            throw new IllegalArgumentException("The length of [" + this.field + "] field of [" + docId + "] doc of [" + this.index + "] index has exceeded [" + this.maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!");
        }
        Snippet[] result = (Snippet[])this.fieldHighlighter.highlightFieldForDoc(reader, docId, fieldValue);
        return result == null ? EMPTY_SNIPPET : result;
    }

    protected BreakIterator getBreakIterator(String field) {
        return this.breakIterator;
    }

    public PassageFormatter getFormatter() {
        return this.passageFormatter;
    }

    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    protected FieldHighlighter newFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter, Comparator<Passage> passageSortComparator) {
        return new CustomFieldHighlighter(field, fieldOffsetStrategy, this.breakIteratorLocale, breakIterator, this.getScorer(field), maxPassages, this.noMatchSize > 0 ? 1 : 0, this.getFormatter(field), this.noMatchSize, passageSortComparator);
    }

    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    private Collection<Query> rewriteCustomQuery(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            if (positionSpanQueries.length == 1) {
                return Collections.singletonList(positionSpanQueries[0]);
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        return null;
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
        if (this.offsetSource == null) {
            return super.getOffsetSource(field);
        }
        return this.offsetSource;
    }

    protected Set<UnifiedHighlighter.HighlightFlag> getFlags(String field) {
        Set flags = super.getFlags(field);
        flags.remove(UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES);
        return flags;
    }
}

