/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import org.opensearch.search.internal.SearchContext;

public class SearchContextSourcePrinter {
    private final SearchContext searchContext;

    public SearchContextSourcePrinter(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.searchContext.indexShard().shardId());
        builder.append(" ");
        if (this.searchContext.request() != null && this.searchContext.request().source() != null) {
            builder.append("source[").append(this.searchContext.request().source().toString()).append("], ");
        } else {
            builder.append("source[], ");
        }
        if (this.searchContext.getTask() != null && this.searchContext.getTask().getHeader("X-Opaque-Id") != null) {
            builder.append("id[").append(this.searchContext.getTask().getHeader("X-Opaque-Id")).append("], ");
        } else {
            builder.append("id[], ");
        }
        return builder.toString();
    }
}

