/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.lucene.analysis.ko.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoDictionaryEntryWriter;
import org.apache.lucene.analysis.morph.BinaryDictionaryWriter;
import org.apache.lucene.analysis.morph.DictionaryEntryWriter;
import org.apache.lucene.util.fst.FST;

class TokenInfoDictionaryWriter
extends BinaryDictionaryWriter<TokenInfoDictionary> {
    private FST<Long> fst;

    TokenInfoDictionaryWriter(int size) {
        super(TokenInfoDictionary.class, (DictionaryEntryWriter)new TokenInfoDictionaryEntryWriter(size));
    }

    public void setFST(FST<Long> fst) {
        Objects.requireNonNull(fst, "dictionary must not be empty");
        this.fst = fst;
    }

    protected void addMapping(int sourceId, int wordId) {
        super.addMapping(sourceId, wordId);
    }

    public void write(Path baseDir) throws IOException {
        super.write(baseDir, "ko_dict_map", "ko_dict_pos", "ko_dict", 1);
        this.writeFST(baseDir.resolve(this.getBaseFileName() + "$fst.dat"));
    }

    private void writeFST(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        this.fst.save(path);
    }
}

