/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.UnknownMorphData;
import org.apache.lucene.analysis.morph.BinaryDictionary;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;

public final class UnknownDictionary
extends BinaryDictionary<UnknownMorphData> {
    private final CharacterDefinition characterDefinition = CharacterDefinition.getInstance();
    private final UnknownMorphData morphAtts;

    public UnknownDictionary(Path targetMapFile, Path posDictFile, Path dictFile) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(targetMapFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(posDictFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(dictFile, new OpenOption[0])));
    }

    public UnknownDictionary(URL targetMapUrl, URL posDictUrl, URL dictUrl) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> targetMapUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> posDictUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> dictUrl.openStream()));
    }

    private UnknownDictionary() throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$targetMap.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$posDict.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$buffer.dat")));
    }

    private UnknownDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> posResource, IOSupplier<InputStream> dictResource) throws IOException {
        super(targetMapResource, dictResource, "ko_dict_map", "ko_dict", 1);
        this.morphAtts = new UnknownMorphData(this.buffer, posResource);
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = UnknownDictionary.class.getSimpleName() + suffix;
        return (InputStream)IOUtils.requireResourceNonNull((Object)UnknownDictionary.class.getResourceAsStream(resourcePath), (String)resourcePath);
    }

    public CharacterDefinition getCharacterDefinition() {
        return this.characterDefinition;
    }

    public static UnknownDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public UnknownMorphData getMorphAttributes() {
        return this.morphAtts;
    }

    private static class SingletonHolder {
        static final UnknownDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new UnknownDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load UnknownDictionary.", ioe);
            }
        }
    }
}

