/**
 * ./src/components/title.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import { Text, Box, Newline } from 'ink';
// pjson
import { createRequire } from 'module';
import Utils from '../../classes/utils.js';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Title({ title = "", version = "" }) {
    let type = "";
    if (!Utils.isAppImage()) {
        type = "native";
    }
    if (title === "")
        title = `${pjson.name}`;
    let green = ` ${title}`.padEnd(25, " ");
    let white = ` Perri's brewery edition `.padEnd(25, " ");
    let red = ` v${pjson.version} ${type} `.padStart(25, " ");
    return (React.createElement(React.Fragment, null,
        React.createElement(Box, { flexDirection: "column" },
            React.createElement(Box, null),
            React.createElement(Box, null,
                React.createElement(Text, null, "E G G S: reproductive system of penguins")),
            React.createElement(Newline, null)),
        React.createElement(Box, { flexDirection: "row" },
            React.createElement(Text, { backgroundColor: "green" }, green),
            React.createElement(Text, { backgroundColor: "white", color: "blue" }, white),
            React.createElement(Text, { backgroundColor: "red" }, red))));
}
