﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastServiceRequest.h>
#include <aws/forecast/ForecastService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ForecastService {
namespace Model {

/**
 */
class DescribeWhatIfAnalysisRequest : public ForecastServiceRequest {
 public:
  AWS_FORECASTSERVICE_API DescribeWhatIfAnalysisRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeWhatIfAnalysis"; }

  AWS_FORECASTSERVICE_API Aws::String SerializePayload() const override;

  AWS_FORECASTSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the what-if analysis that you are
   * interested in.</p>
   */
  inline const Aws::String& GetWhatIfAnalysisArn() const { return m_whatIfAnalysisArn; }
  inline bool WhatIfAnalysisArnHasBeenSet() const { return m_whatIfAnalysisArnHasBeenSet; }
  template <typename WhatIfAnalysisArnT = Aws::String>
  void SetWhatIfAnalysisArn(WhatIfAnalysisArnT&& value) {
    m_whatIfAnalysisArnHasBeenSet = true;
    m_whatIfAnalysisArn = std::forward<WhatIfAnalysisArnT>(value);
  }
  template <typename WhatIfAnalysisArnT = Aws::String>
  DescribeWhatIfAnalysisRequest& WithWhatIfAnalysisArn(WhatIfAnalysisArnT&& value) {
    SetWhatIfAnalysisArn(std::forward<WhatIfAnalysisArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_whatIfAnalysisArn;
  bool m_whatIfAnalysisArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
