﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/Table.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class GetTablesResult {
 public:
  AWS_GLUE_API GetTablesResult() = default;
  AWS_GLUE_API GetTablesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API GetTablesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of the requested <code>Table</code> objects.</p>
   */
  inline const Aws::Vector<Table>& GetTableList() const { return m_tableList; }
  template <typename TableListT = Aws::Vector<Table>>
  void SetTableList(TableListT&& value) {
    m_tableListHasBeenSet = true;
    m_tableList = std::forward<TableListT>(value);
  }
  template <typename TableListT = Aws::Vector<Table>>
  GetTablesResult& WithTableList(TableListT&& value) {
    SetTableList(std::forward<TableListT>(value));
    return *this;
  }
  template <typename TableListT = Table>
  GetTablesResult& AddTableList(TableListT&& value) {
    m_tableListHasBeenSet = true;
    m_tableList.emplace_back(std::forward<TableListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A continuation token, present if the current list segment is not the
   * last.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetTablesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTablesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Table> m_tableList;
  bool m_tableListHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
