/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.importer.Location;
import java.util.function.Predicate;
import java.util.regex.Pattern;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public interface ImportOption {
    public boolean includes(Location var1);

    public static final class DoNotIncludePackageInfos
    implements ImportOption {
        private static final Pattern PACKAGE_INFO_PATTERN = Pattern.compile(".*package-info\\.class$");

        @Override
        public boolean includes(Location location) {
            return !location.matches(PACKAGE_INFO_PATTERN);
        }
    }

    public static final class DoNotIncludeArchives
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isArchive();
        }
    }

    public static final class DoNotIncludeJars
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isJar();
        }
    }

    public static final class DoNotIncludeGradleTestFixtures
    implements ImportOption {
        private static final Pattern TEST_FIXTURES_FILE_PATH_PATTERN = Pattern.compile(".*/build/classes/.*/testFixtures/.*");
        private static final Pattern TEST_FIXTURES_JAR_PATH_PATTERN = Pattern.compile(".*/build/libs/.*-test-fixtures.jar!.*");

        @Override
        public boolean includes(Location location) {
            return !location.matches(TEST_FIXTURES_FILE_PATH_PATTERN) && !location.matches(TEST_FIXTURES_JAR_PATH_PATTERN);
        }
    }

    public static final class OnlyIncludeTests
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return Predefined.TEST_LOCATION.test(location);
        }
    }

    public static final class DoNotIncludeTests
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return Predefined.NO_TEST_LOCATION.test(location);
        }
    }

    public static enum Predefined implements ImportOption
    {
        DO_NOT_INCLUDE_TESTS{
            private final DoNotIncludeTests doNotIncludeTests = new DoNotIncludeTests();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeTests.includes(location);
            }
        }
        ,
        ONLY_INCLUDE_TESTS{
            private final OnlyIncludeTests onlyIncludeTests = new OnlyIncludeTests();

            @Override
            public boolean includes(Location location) {
                return this.onlyIncludeTests.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_TEST_FIXTURES{
            private final DoNotIncludeGradleTestFixtures doNotIncludeGradleTestFixtures = new DoNotIncludeGradleTestFixtures();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeGradleTestFixtures.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_JARS{
            private final DoNotIncludeJars doNotIncludeJars = new DoNotIncludeJars();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeJars.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_ARCHIVES{
            private final DoNotIncludeArchives doNotIncludeArchives = new DoNotIncludeArchives();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeArchives.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_PACKAGE_INFOS{
            private final DoNotIncludePackageInfos doNotIncludePackageInfos = new DoNotIncludePackageInfos();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludePackageInfos.includes(location);
            }
        };

        static final PatternPredicate MAVEN_TEST_PATTERN;
        static final PatternPredicate GRADLE_TEST_PATTERN;
        static final PatternPredicate INTELLIJ_TEST_PATTERN;
        static final Predicate<Location> TEST_LOCATION;
        static final Predicate<Location> NO_TEST_LOCATION;

        static {
            MAVEN_TEST_PATTERN = new PatternPredicate(".*/target/test-classes/.*");
            GRADLE_TEST_PATTERN = new PatternPredicate(".*/build/classes/([^/]+/)?test/.*");
            INTELLIJ_TEST_PATTERN = new PatternPredicate(".*/out/test/.*");
            TEST_LOCATION = MAVEN_TEST_PATTERN.or(GRADLE_TEST_PATTERN).or(INTELLIJ_TEST_PATTERN);
            NO_TEST_LOCATION = TEST_LOCATION.negate();
        }

        private static class PatternPredicate
        implements Predicate<Location> {
            private final Pattern pattern;

            PatternPredicate(String pattern) {
                this.pattern = Pattern.compile(pattern);
            }

            @Override
            public boolean test(Location input) {
                return input.matches(this.pattern);
            }
        }
    }
}

