/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.TokenType;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeDialog;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FormulaUtils;
import org.freeplane.view.swing.ui.mindmapmode.GlassPaneManager;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;

class FormulaEditor
extends EditNodeDialog
implements INodeSelector {
    private static final String PASSED_WIDTH_PROPERTY = "formulaDialog.passed.width";
    private static final String PASSED_HEIGHT_PROPERTY = "formulaDialog.passed.height";
    private static final String FAILED_WIDTH_PROPERTY = "formulaDialog.failed.width";
    private static final String FAILED_HEIGHT_PROPERTY = "formulaDialog.failed.height";
    static final String GROOVY_EDITOR_FONT = "groovy_editor_font";
    static final String GROOVY_EDITOR_FONT_SIZE = "groovy_editor_font_size";
    private JEditorPane textEditor;
    private MapExplorerController mapExplorer;
    private EvaluationStatus evaluationStatus;

    FormulaEditor(MapExplorerController mapExplorer, NodeModel nodeModel, AWTEvent firstEvent, EditNodeBase.IEditControl editControl, boolean enableSplit, JEditorPane textEditor) {
        super(nodeModel, firstEvent, true, editControl, enableSplit, textEditor);
        this.mapExplorer = mapExplorer;
        this.textEditor = textEditor;
        this.evaluationStatus = EvaluationStatus.PASSED;
    }

    public void show(Window window) {
        if (window instanceof RootPaneContainer) {
            this.textEditor.addAncestorListener((AncestorListener)new GlassPaneManager(((RootPaneContainer)((Object)window)).getRootPane(), (INodeSelector)this));
        }
        super.show(window);
    }

    protected void configureDialog(JDialog dialog) {
        this.addPreviewPane(dialog);
        dialog.setModal(false);
    }

    private void addPreviewPane(JDialog dialog) {
        String content = this.getText();
        try {
            FormulaUtils.evalIfScript((NodeModel)this.getNode(), (String)content);
            this.evaluationStatus = EvaluationStatus.PASSED;
        }
        catch (ExecuteScriptException e) {
            StringWriter out = new StringWriter();
            try (PrintWriter writer = new PrintWriter(out);){
                e.printStackTrace(writer);
            }
            JTextArea exceptionView = new JTextArea(out.toString());
            exceptionView.setBackground(Color.LIGHT_GRAY);
            exceptionView.setForeground(Color.RED.darker());
            Font font = this.textEditor.getFont();
            exceptionView.setFont(font.deriveFont(font.getSize2D() * 0.8f));
            exceptionView.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(exceptionView, 22, 30);
            UITools.setScrollbarIncrement((JScrollPane)scrollPane);
            Rectangle availableScreenBounds = UITools.getAvailableScreenBounds((Component)UITools.getCurrentRootComponent());
            Dimension maximumSize = new Dimension(availableScreenBounds.width * 3 / 4, Integer.MAX_VALUE);
            Dimension preferredSize = scrollPane.getPreferredSize();
            preferredSize.width = Math.min(preferredSize.width, maximumSize.width);
            preferredSize.height = 0;
            scrollPane.setPreferredSize(preferredSize);
            Box resisablePreview = Box.createHorizontalBox();
            dialog.add((Component)resisablePreview, "East");
            this.evaluationStatus = EvaluationStatus.FAILED;
        }
    }

    public void nodeSelected(NodeModel node) {
        String replacement = this.isCaretInsideStringToken() ? this.mapExplorer.getNodeReferenceSuggestion(node) : this.createReference(node);
        this.replaceSelectedText(replacement);
    }

    private void replaceSelectedText(String replacement) {
        this.textEditor.replaceSelection(replacement);
        this.textEditor.requestFocus();
        SwingUtilities.getWindowAncestor(this.textEditor).toFront();
    }

    private String createReference(NodeModel node) {
        if (node == this.getNode()) {
            return "node";
        }
        if (!this.mapExplorer.isGlobal(node)) {
            return node.getID();
        }
        String alias = this.mapExplorer.getAlias(node);
        if (alias.isEmpty()) {
            return node.getID();
        }
        return "at(':~" + alias + "')";
    }

    public void tableRowSelected(NodeModel node, String rowName) {
        if (this.isCaretInsideStringToken()) {
            return;
        }
        String replacement = this.createReference(node) + "['" + rowName + "']";
        this.replaceSelectedText(replacement);
    }

    private boolean isCaretInsideStringToken() {
        int caretPosition = this.textEditor.getCaretPosition();
        SyntaxDocument document = (SyntaxDocument)this.textEditor.getDocument();
        Token token = document.getTokenAt(caretPosition);
        boolean caretInsideStringToken = TokenType.isString((Token)token);
        return caretInsideStringToken;
    }

    protected void saveDialogSize(JDialog dialog) {
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.setProperty(this.evaluationStatus.widthPropertyName, dialog.getWidth());
        resourceController.setProperty(this.evaluationStatus.heightPropertyName, dialog.getHeight());
    }

    protected void restoreDialogSize(JDialog dialog) {
        Dimension preferredSize = dialog.getPreferredSize();
        ResourceController resourceController = ResourceController.getResourceController();
        preferredSize.width = Math.max(preferredSize.width, resourceController.getIntProperty(this.evaluationStatus.widthPropertyName, 0));
        preferredSize.height = Math.max(preferredSize.height, resourceController.getIntProperty(this.evaluationStatus.heightPropertyName, 0));
        dialog.setPreferredSize(preferredSize);
    }

    static enum EvaluationStatus {
        PASSED("formulaDialog.passed.width", "formulaDialog.passed.height"),
        FAILED("formulaDialog.failed.width", "formulaDialog.failed.height");

        public final String heightPropertyName;
        public final String widthPropertyName;

        private EvaluationStatus(String widthPropertyName, String heightPropertyName) {
            this.heightPropertyName = heightPropertyName;
            this.widthPropertyName = widthPropertyName;
        }
    }
}

