#############################################################################
##
#W  epifromfpgroupto_ct23z.g         GAP4 Package `RCWA'          Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing an epimorphism
##  from a finitely presented group to CT_{2,3}(Z).
##
##  The group presentation of the source of the epimorphism must be adapted
##  in the event that other generators for CT_{2,3}(Z) are used.
##
##  While CT_{2,3}(Z) is generated by 6 class transpositions, for convenience
##  this epimorphism is part of the said data library.
##
#############################################################################

local  phi, CT23Z, H, rels, F, a, b, c, d, e, f;

F := FreeGroup("a","b","c","d","e","f");
a := F.1; b := F.2; c := F.3; d := F.4; e := F.5; f := F.6;

rels :=
[ a^2, b^2, c^2, d^2, e^2, f^2, (b*c)^3, (a*b)^4, (a*c)^4, 
  a*c*b*c*a*(b*a*c)^2, b*c*(f*b*c*b)^2*f*c, (c*b*c*f)^3, (d*f)^6, (f*e)^6, 
  (f*c)^6, (b*e)^6, ((f*c)^2*f*a*c)^2, (b*e)^2*b*f*(b*e)^3*f*e, 
  (f*d*(e*f)^2*d)^2, (a*e*f*e)^4, (a*c*a*f)^4, (a*e*b*e)^4, 
  (f*a*b*f*b*a*b*c*b)^2, a*c*a*f*c*f*b*f*c*f*a*c*a*b*c*f*c*b, (a*b*f*b*a*f)^3,
  (d*e*f*e*d*f)^3, (a*c*e)^6, (d*f*e*d*f)^4, ((c*a)^2*f*c*b*f*c*f)^2, 
  (a*b*a*c)^5, (a*c*b*(f*c)^2*f*b*c)^2, (a*b*(f*c)^2*f*b*a*e)^2, 
  a*c*a*(e*b*e*(a*c)^2)^2*e*b*e*c, b*c*a*f*c*b*c*f*a*c*b*f*b*c*a*c*b*(f*c)^2, 
  (f*a*b*f*a*c*b)^3, (a*b*c*a*f*b*c)^3, 
  a*b*f*b*c*b*a*c*b*f*b*a*f*(c*a)^2*b*(f*c)^2, 
  a*(c*f)^2*(c*a)^2*f*a*b*(c*f)^2*(c*a)^2*f*b, (a*b*(f*c)^3*b*a*f)^2, 
  a*c*b*c*f*b*a*(c*f)^2*b*(c*a)^2*f*a*b*f*b*c, (a*c*a*f*b*c*a*b*c*b*f)^2, 
  c*b*a*f*c*f*b*c*f*c*b*f*c*f*a*b*a*(f*c)^2*f, 
  a*b*f*b*a*b*(c*f)^3*b*f*b*(c*f)^3*b, 
  f*b*a*f*a*c*(a*f)^2*c*f*b*c*f*c*b*f*(c*a)^2, (a*c*b*c*f*a*c*a*f*b*c)^2, 
  a*b*f*a*c*a*f*b*c*a*f*a*c*b*f*a*c*a*f*b*a*f, (a*c*b*f*b*c*a*f*b*a*f)^2, 
  a*b*c*a*f*a*b*f*b*c*a*f*b*a*c*b*c*f*b*c*a*f*b, 
  a*b*c*a*b*(f*c)^2*f*b*a*c*b*a*b*(f*c)^3*b, 
  f*c*f*b*c*a*(f*c)^2*f*a*b*(f*c)^2*f*b*a*b*f*c, 
  a*b*(c*f)^2*b*a*c*a*f*(c*f*b)^2*(f*c)^2*f*b, 
  a*b*f*b*a*f*c*b*(f*c)^2*(b*a*f)^2*a*b*f*c*b*c, 
  a*b*a*c*a*f*c*f*b*(a*c)^2*f*(a*c)^2*b*f*c*f*a*c, (c*b*c*e)^6, 
  b*a*b*f*a*b*a*c*(b*f)^2*c*f*b*c*f*c*b*f*b*c*f*a, b*c*(e*b*c*b)^5*e*c, 
  (a*b*c*b*a*e)^4, (a*c*b*c*a*e)^4, 
  b*a*c*b*f*a*b*f*b*c*b*a*b*c*b*(f*c)^2*b*a*f*a*c, (a*f*c*b*c*f)^4, 
  a*b*(f*c)^2*f*a*c*b*a*c*f*a*b*f*a*c*a*f*b*a*f*c, (b*f*e*f)^6, 
  (a*e*c*f*c*e)^4, (a*c*(a*f)^2)^4, (a*d*a*e*b*e)^4, (d*e*d*f)^6, 
  (a*c*d*e*d*c)^4, (a*e*f*b*f*e)^4, (a*c*a*f*c*f)^4, (a*e*d*b*d*e)^4, 
  (a*b*c*f*c*b*a*(f*c)^2*f)^2, (a*e*b*f*b*e)^4, (a*c*b*f*b*c)^4, 
  (a*b*f)^3*b*a*f*c*b*f*(c*f*b)^2*c*a*f, (a*b*c*f*c*b)^4, (a*d*a*e*f*e)^4, 
  (a*e*c*e*a*f)^4, a*b*c*f*a*c*a*f*c*b*f*b*c*f*a*c*a*f*c*b*a*b*f*b, 
  (a*b*e*c)^6, ((a*e)^2*b*e)^4, (b*e*c*e*b*f)^4, 
  a*b*f*b*a*f*c*(f*c*f*b)^3*(f*c)^2*f, (b*d*e*d)^6, (a*e*d*f*d*e)^4, 
  a*b*f*b*a*(b*f*c*f)^2*b*a*b*f*b*a*(f*c)^2*f, ((a*e)^2*a*f)^4, 
  ((a*e)^2*f*e)^4, (a*c*b*f)^6, 
  (b*a)^2*c*a*f*a*b*a*c*b*f*b*c*a*b*a*f*b*(f*c)^2*f, 
  a*b*a*c*b*f*(a*c)^2*f*c*f*a*c*a*b*f*c*f*(a*c)^2*f, 
  b*a*b*f*b*c*a*b*a*f*c*b*f*c*f*b*c*a*b*f*a*c*a*f*a, (b*c*f*c*e)^5, 
  a*(b*a*f*(a*b)^2*f)^2*(a*b)^2*f*b*a*f*b, 
  (b*a)^2*c*a*b*f*b*a*c*(f*b*a)^2*f*a*b*c*(b*a)^2*f, 
  a*(b*f*c)^2*f*b*a*c*a*b*f*(c*f*b)^2*a*f*c*b*c*f, 
  a*b*a*f*b*a*b*c*a*f*b*c*b*f*a*c*a*f*a*b*f*b*a*f*b*c, 
  (a*c*b*(f*c)^2*f*b*c*b*a*f)^2, 
  a*(c*b*f)^2*c*f*b*c*a*f*(c*f*b)^2*f*c*b*f*c*f*b, 
  a*b*a*c*b*f*(a*b)^2*f*b*c*a*(b*a*f)^2*b*c*b*f*a*b*f, 
  (b*a)^2*f*c*f*b*a*b*f*c*f*b*c*f*c*a*b*a*c*a*b*f*b*a*c, 
  a*b*a*c*f*b*a*b*f*c*f*b*c*f*c*b*f*(a*b)^2*(f*c)^2*f*b, (b*(f*c)^3*b*e)^3, 
  a*b*c*e*b*(f*c)^3*b*e*c*b*a*(f*c)^2*f*e*(f*c)^2*f, 
  a*b*a*c*b*f*b*a*f*b*c*a*(c*f)^2*c*a*b*f*b*c*a*f*a*b*f, 
  a*(b*a*f)^2*b*(f*c)^2*f*a*b*c*(a*f*b)^2*(f*c)^2*f, 
  a*b*a*c*b*f*a*c*b*a*b*f*b*a*b*c*a*c*f*(c*f*b)^2*a*f, (b*(f*c)^2*f*b*a*c)^3, 
  b*a*c*b*f*b*a*b*(f*c)^2*(f*b)^2*(f*c)^2*f*b*a*b*f*a*c, 
  a*b*f*a*(c*f)^2*c*b*a*b*f*(c*f*b)^2*f*(b*f*c)^2*f*b, (a*b*c*b*d*c*b)^4, 
  (a*(b*e)^3)^4, a*b*a*f*b*c*a*b*c*(b*f*a)^2*c*a*f*a*c*(b*f)^2*(c*f)^2, 
  (c*b*c*(d*f)^2)^4, a*c*a*((e*a)^2*c*a*c)^3*e*a*e*c, (a*b*c*d*c*b*c)^4, 
  b*a*b*f*a*f*b*a*b*f*(c*f*b)^2*(c*f)^2*b*a*b*f*b*a*c*a, 
  a*b*f*b*a*b*f*c*f*b*(a*c)^2*f*c*b*a*b*f*b*a*c*f*a*c*a*f, 
  a*b*a*(f*b*f*(a*b)^2)^3*(f*b)^2, (b*(d*f)^3)^4, 
  b*c*((d*f)^2*b*c*b)^3*(d*f)^2*c, c*b*c*(e*b)^2*e*(c*(e*b)^3)^2*c*(e*b)^2*e, 
  (a*f*c*b*f*c*f)^2*(a*f*c*f*b*c*f)^2, (a*b*a*d*b*f*d)^4, (c*(d*f)^2*c*f)^4, 
  (a*(b*f)^2*a*f)^4, (a*b*a*(d*f)^2)^4, (a*b*e*f*b*a*f)^4, (a*c*b*e)^7, 
  (a*(d*f)^2*a*f)^4, (a*b*f*b*a*d*f)^4, (a*d*a*f*a*d*f)^4, 
  a*b*c*a*b*f*b*c*a*f*c*b*f*b*c*f*a*c*b*f*b*a*c*b*a*b*f*b, (a*b*e*c*a*e*c)^4, 
  (a*d*(b*f)^2*d)^4, (b*c*f*c*e*b*e)^4, (a*b*e*a*c*e*c)^4, (a*b*f*b*a*e*f)^4, 
  (a*b*a*f)^2*((c*f)^2*b)^2*f*b*c*f*c*b*(f*c)^2, (a*b*f*a*d*b*d)^4, 
  a*b*a*c*a*b*f*b*a*c*a*b*a*f*c*f*b*a*b*c*f*c*b*a*b*f*c*f, (c*(e*f)^2*c*f)^4, 
  (b*a)^2*f*b*c*a*c*b*a*c*f*b*a*f*b*c*a*b*a*f*c*a*b*f*b*a*c, 
  a*c*b*c*f*a*f*b*a*(c*f)^2*b*f*b*(c*a)^2*f*a*b*f*a*c*f*b*c, 
  a*c*a*(e*(a*c)^2)^5*e*c, a*c*a*(f*(a*c)^2)^5*f*c, 
  a*b*a*c*a*b*f*a*f*b*a*c*(a*b)^2*f*b*f*c*f*b*a*b*f*c*(f*b)^2, 
  (d*(e*f)^2)^2*d*(e*f*e*d*f)^2*(e*f)^2*d*(e*f)^2, 
  (b*a)^2*f*c*b*a*b*c*f*b*c*a*b*a*f*b*c*a*c*b*a*b*c*a*f*b*a*c, 
  ((b*a)^2*f)^2*b*a*(c*b*f*c*f)^2*c*(f*b)^2*c*a*f, 
  b*c*f*a*c*a*f*c*a*b*a*f*c*f*b*a*c*f*a*c*a*f*a*b*c*f*c*b*a*c, (a*c*e*d*e)^6, 
  a*b*f*c*b*f*b*c*f*b*a*f*c*b*f*c*f*a*c*b*f*b*c*a*f*c*f*b*c*f, (a*b*f)^10, 
  (a*c*e*c*a*e)^5, (a*d*b*f*d)^6, (a*(b*f)^2)^6, (a*c*e*b*e)^6, 
  (a*(d*f)^2)^6, (b*a)^2*c*a*b*f*a*b*c*b*a*f*c*f*b*c*a*c*b*f*b*a*f*c*b*a*b*c*f,
  b*a*b*f*a*b*c*a*c*f*b*c*a*f*a*c*b*f*b*a*f*c*b*a*c*b*f*b*a*c*a, 
  a*b*a*c*b*(f*a)^2*c*a*f*c*b*f*b*c*a*c*b*f*(a*c)^2*f*c*b*c*a*f, 
  b*f*a*c*b*a*f*b*c*b*a*c*b*f*c*a*b*c*a*f*c*b*f*c*f*b*a*c*f*b*c, 
  a*b*a*c*a*b*f*c*f*a*f*b*a*b*f*(c*f*b)^2*f*(c*a)^2*b*a*b*f*b, 
  b*a*c*b*f*a*f*c*f*b*c*a*b*f*c*b*f*b*c*f*b*a*b*c*b*f*c*a*f*b*c, 
  a*b*a*f*a*c*b*c*a*(f*c)^2*(f*b*a)^2*c*(a*b)^2*f*c*f*b*a*c*b, 
  a*b*c*e*c*b*a*(f*c)^2*f*e*c*a*b*(f*c)^3*b*a*c*e*(f*c)^2*f, 
  (b*a)^2*f*c*f*b*(a*c)^2*f*c*b*a*(c*b*f)^2*c*f*b*a*b*c*f*a*c, 
  a*b*a*c*f*b*a*f*a*c*a*f*c*b*f*(c*f*b)^2*a*c*a*b*a*(f*c)^2*f, 
  b*a*b*f*b*c*f*b*a*b*f*c*f*b*c*(f*b*a*c*b)^2*a*b*f*b*a*c*a, 
  (b*a)^2*f*b*c*a*b*a*f*a*b*(c*f)^2*c*a*b*f*b*a*f*a*b*a*c*a*b*a*f, 
  (b*a)^2*f*b*a*c*a*b*a*f*c*f*a*c*a*b*f*c*f*b*a*b*(c*a)^2*f*b*a*c, 
  a*b*a*c*b*f*c*a*f*c*b*c*f*c*a*b*(f*c)^2*b*c*a*b*f*c*f*b*c*f*a*f, 
  (a*b*c*f*c*b*a*f*c*f*(a*c)^2*f*c)^2, 
  a*b*f*c*(b*f)^2*c*f*b*a*c*a*b*f*c*(f*b)^2*c*f*b*a*f*c*b*f*b*c*f, 
  a*b*(c*f)^2*b*c*a*c*b*a*b*c*f*(c*f*b)^2*a*f*c*b*(f*c)^2*a*c*b, 
  a*b*a*f*c*a*b*c*f*b*a*c*a*b*a*f*c*f*b*a*c*f*c*b*f*c*f*a*c*f*b*c, 
  (a*c*d*c)^8, a*b*a*c*f*(c*f*b)^2*f*b*c*a*b*(c*f)^3*b*f*a*f*b*c*a*c*b*c*f, 
  a*b*a*f*c*b*f*c*f*b*a*b*c*f*b*f*c*f*b*a*b*f*c*f*a*c*(a*b)^2*(f*c)^2, 
  a*b*a*c*b*f*a*b*a*c*(f*b*c*a*c*b*f*c*f*a)^2*b*c*b*a*f, 
  (b*a)^2*f*b*c*a*b*a*(f*c)^2*f*(b*a)^2*c*a*f*c*f*b*a*c*(b*a)^2*f*b*a*c, 
  a*(b*f*c*f)^2*b*a*c*f*a*c*b*f*a*f*c*f*b*c*a*c*b*f*c*a*f*b*c*a*f*c, 
  a*b*c*a*f*c*b*f*c*f*b*a*c*b*a*f*c*f*b*c*f*a*c*b*f*a*c*f*b*c*a*c*b*c*f, 
  a*b*a*c*a*b*f*a*b*c*a*c*f*b*c*a*c*b*f*c*f*a*c*b*a*f*b*a*c*a*b*a*c*f*c, 
  a*b*a*c*a*b*f*a*b*a*f*b*c*a*f*c*b*f*c*f*a*b*c*(b*f)^2*c*f*b*a*b*f*c*f, 
  (a*b*e*b*c)^7, (a*c*(e*b)^2*e)^5, (a*b*f*b*c*a*f)^5, (a*b*e*f*e*b*c)^5, 
  (c*b*c*d*f*d)^6, b*c*(d*f*d*b*c*b)^5*d*f*d*c, b*c*(e*c*e*b*c*b)^5*(e*c)^2, 
  (c*b*(c*e)^2)^6, 
  a*b*a*c*a*b*f*a*f*b*a*(f*c)^2*f*a*b*f*a*f*b*a*c*(a*b)^2*f*b*c*f*c*b*f*b, 
  (b*c*d*c*b*f)^6, (c*(f*e)^2*f)^6, (a*b*e*c*e*b)^6, (b*e*c*f*c*e)^6, 
  (a*(b*e)^2*c)^6, (a*b*d*b*a*f)^6, (a*b*f*b*a*d)^6, (b*d*e*d*b*f)^6, 
  ((b*f)^2*e*f)^6, (a*b*e*d*e*c)^6, ((c*f)^2*e*f)^6, (a*e*b*e*a*f)^6, 
  (a*b*a*c*d*c)^6, (a*b*f*c*a*d)^6, (c*e*f*e*c*f)^6, (a*b*c*e*(f*c)^2*f)^4, 
  (a*c*b*e*d*e)^6, (b*f*d*c*d*f)^6, ((a*f)^2*e*f)^6, (a*c*f*c*a*e)^6, 
  (a*b*a*c*a*f)^6, (a*c*e*b*e*c)^6, (b*e*f*e*b*f)^6, ((b*e)^2*c*e)^6, 
  (a*d*f*b*f*d)^6, (a*c*b*f*e*f)^6, (b*d*c*e*c*d)^6, ((d*f)^2*e*f)^6, 
  (a*c*a*e*f*e)^6, (b*d*f*e*f*d)^6, (a*b*e*b*a*f)^6, (c*(f*d)^2*f)^6, 
  (c*d*f*d*c*f)^6, (a*e*f*e*a*f)^6, (c*d*(c*e)^2)^6, 
  (b*a)^2*c*a*b*f*a*c*f*b*a*c*(b*a)^2*f*b*(a*c)^2*f*c*b*a*b*f*c*f*b*(c*f)^2, 
  a*b*a*c*b*f*(c*b*a)^2*f*c*f*b*c*f*a*c*b*f*a*f*c*f*b*c*a*c*b*f*a*b*c*a*f, 
  a*b*a*c*a*b*f*(a*b)^2*(c*f)^2*b*c*f*a*f*c*b*c*f*b*f*c*(b*f)^2*c*f*b*a*b*f*c,
  (b*a)^2*f*b*c*f*c*a*b*a*c*a*b*f*a*c*b*a*b*c*b*f*b*a*c*(b*a)^2*f*c*a*f*b*a*c,
  (b*a)^2*f*c*f*a*c*b*a*b*f*c*f*b*a*c*a*(f*c)^2*b*a*b*c*a*f*b*a*c*a*b*a*f*b*a*c,
  a*b*a*f*(a*c*b)^2*c*f*(b*a)^2*c*a*b*f*c*f*a*f*b*a*c*(b*a)^2*f*b*c*f*b*a*c*b,
  (a*b*(f*c)^3*b*a*c*e*c)^3, 
  a*b*a*c*a*b*f*a*b*c*a*c*f*b*a*(f*c)^2*f*b*(c*f*a)^2*b*(a*c*b*f*c)^2*f, 
  a*b*a*c*b*f*a*b*c*f*(a*c*f*c*b*c*a*c*b*f*c)^2*b*a*f*c*b*a*c*f, 
  a*b*a*c*a*b*f*a*c*(a*b)^2*f*c*f*b*c*f*a*c*b*f*a*c*a*f*c*b*a*f*c*(f*c*f*b)^2,
  (a*b*d*b*f)^8, (a*c*e*a*e)^8, 
  a*b*a*f*a*c*a*b*(f*c)^2*f*a*b*f*c*f*b*c*a*b*f*c*(b*f)^2*c*f*b*c*a*c*b*a*b*f*b*a*c,
  a*c*a*(f*b*f*(a*c)^2)^5*f*b*f*c, (b*(c*f)^3)^6, (a*c*b*f*b*c*b)^6, 
  (a*f*c*b*c*f*b)^6, a*b*a*((f*a)^2*b*a*b)^5*f*a*f*b, (a*f*b*c*b*f*b)^6, 
  a*c*a*(f*c*f*(a*c)^2)^5*(f*c)^2, a*(b*f*d*(a*c)^2)^5*b*f*d*c*a*c, 
  a*b*a*(e*f*e*(a*b)^2)^5*e*f*e*b, a*c*a*(e*d*e*(a*c)^2)^5*e*d*e*c, 
  (a*b*f*d*c*a*c)^6, (a*c*b*(f*e)^2)^6, ((b*d)^2*f*b*f)^6, (a*e*(c*f)^2*e)^6, 
  (b*c*e*b*f*b*e)^6, (a*b*a*f*a*b*f)^6, (a*b*a*c*b*f)^7, (a*(b*f)^3)^6, 
  (a*c*b*(e*f)^2)^6, (a*e*b*c*f*c*e)^6, (a*e*(d*f)^2*e)^6, (a*b*d*b*f*d*b)^6, 
  (a*b*(d*f)^2*b)^6, (c*d*c*(e*f)^2)^6, a*b*c*a*(d*(a*c*b)^2)^5*d*b*c, 
  (a*c*e*b*e*a*f)^6, ((c*e)^2*f*e*f)^6, (a*c*(e*f)^2*c)^6, (a*c*a*f*c*e*f)^6, 
  (a*b*f*(a*d)^2)^6, (a*c*a*f*b*c*f)^6, (a*b*c*a*f*b)^7, (a*b*f*b*d*a*f)^6, 
  (a*c*(b*f)^2)^7, (a*b*(f*a)^2*f)^6, (a*f*b*d*f*b*f)^6, (a*c*a*f*a*e*f)^6, 
  (a*b*f*b*e*a*f)^6, (a*b*c*a*c*d*c)^6, (a*c*b*f*d*f)^7, (a*e*b*c*e*a*f)^6, 
  (a*b*f*d*b*d*f)^6, (a*c*d*f*b*d*f)^6, (a*b*d*f*b*f*d)^6, (a*c*b*f*e)^9, 
  (a*c*b*e*f)^9, (a*b*e*c*a*c)^8, a*(b*e*(a*c)^2)^7*b*e*c*a*c, (b*e*f*e)^12, 
  (b*e*b*f)^12, (b*e*c*e)^12, (c*d*c*e)^12, (a*c*b*f*a*f)^8, (a*c*b*e*a*e)^8, 
  (a*b*c*a*e*c)^8, (a*b*e*a*e*c)^8, (b*d*c*d)^12, (a*b*e*b)^12, 
  (a*c*f*d*f*c)^8, (c*e*c*f)^12, (c*d*f*d)^12, (a*e*a*f)^12, (c*e*f*e)^12, 
  (b*e*d*e)^12, (a*c*b*d*b*f)^8, (a*c*b*d*b*c)^8, (c*d*c*f)^12, (d*e*f*e)^12, 
  (a*c*b*e*a*c*e)^7, (a*c*b*e*d*f*e)^7, (a*c*e*f*c*a*e)^7, (a*c*b*e*f*d*e)^7, 
  (a*b*e*b*a*c*f)^7, (a*b*c*a*f*c*f)^7, (a*c*b*e*c*a*e)^7, (a*b*f*a*f)^10, 
  (a*c*e*b*f)^10, (a*b*d*f*b)^10, (c*(e*f)^2)^10, (c*(d*f)^2)^10, 
  (a*e*b*f*a*f)^9, a*b*a*(f*a*d*(a*b)^2)^7*f*a*d*b, 
  a*b*a*(d*a*f*(a*b)^2)^7*d*a*f*b, (a*c*f*e*a*e*f)^8, (a*c*(e*b)^2*f)^8, 
  (a*c*e*a*d*a*e)^8, (a*b*e*a*e*b*c)^8, (a*b*e*c*e*b*c)^8, (a*c*a*f*a*c*f)^8, 
  (a*c*(e*a)^2*e)^8, (a*(c*e)^2*a*e)^8, (c*b*c*d)^15, (a*b*f*b*c*b)^10, 
  (a*b*f*c*b*c)^10, b*c*(d*b*c*b)^14*d*c, (c*b*c*f*d*f)^10, 
  b*c*(f*d*f*b*c*b)^9*f*d*f*c, (a*e*b*e*c*e)^10, (a*c*(b*e)^2)^10, 
  (a*c*b*e*f*e)^10, (a*d*f*a*f)^12, (c*d)^30, (a*b*c*a*e*b*e)^9, 
  (a*c*e*a*c*f*e)^9, (a*c*b*f*e*b*e)^9, (a*c*(b*e)^2*f)^9, (a*b*e*a*c*a*f)^9, 
  (a*c*e*d*e*b*f)^9, (a*c*b*e*c*f*e)^9, (a*c*b*e*f*c*e)^9, (a*b*c*a*c*f*c)^9, 
  (a*b*c*a*c*f*b)^9, (a*b*c*a*f*c*b)^9, (a*c*b*f*e*d*e)^9, (a*c*b*e*d*e*f)^9, 
  b*c*((e*f)^2*b*c*b)^9*(e*f)^2*c, (b*(e*f)^3)^10, (c*b*c*(e*f)^2)^10, 
  (a*c*e*c*f*c*e)^10, (a*b*f*b*a*c*f)^10, ((a*e*f)^2*e)^10, 
  (a*c*a*e*b*e*f)^10, (b*(d*f)^2*b*e)^10, (a*b*f*a*d*f*d)^10, 
  ((d*e)^2*f*e*f)^10, (a*c*e*b*f*b*e)^10, (a*c*(b*f)^2*e)^10, 
  (a*b*a*d*a*b*f)^10, (a*(c*e)^2)^14, ((a*b*f)^2*b)^10, (a*(b*e)^2*b*c)^10, 
  (a*c*e*a*f*c*f)^10, ((a*c*e)^2*c)^10, (c*e*(d*f)^2*e)^10, 
  (a*c*a*(d*f)^2)^10, (a*b*f*c*a*c*f)^10, (a*b*a*c*e*a*f)^10, 
  ((a*e)^2*f*e*f)^10, (a*b*e*a*f*a*c)^10, (a*c*b*e*f*b*f)^10, 
  (a*b*e*b*f*b*c)^10, (b*e*(d*f)^2*e)^10, (a*c*e*a*f*a*e)^10, 
  (a*c*a*(e*f)^2)^10, (b*(d*f)^2*b*f)^10, (c*e*d*f*d*e*f)^10, 
  (c*b*c*f*e*f)^12, (c*b*c*d*b*d)^12, b*c*(f*e*f*b*c*b)^11*f*e*f*c, 
  b*c*((d*b)^2*c*b)^11*d*b*d*c, b*c*(e*f*e*b*c*b)^11*e*f*e*c, 
  (c*b*c*e*f*e)^12, ((c*e)^2*c*f)^12, (a*b*a*c*e*c)^12, (a*b*a*c*f*c)^12, 
  (b*f*e*c*e*f)^12, (a*b*e*b*a*c)^12, (a*d*e*d*a*f)^12, (a*b*e*b*a*e)^12, 
  (b*c*e*c*b*e)^12, (a*b*c*e*c*b)^12, (b*d*b*e*f*e)^12, (a*c*a*d*f*d)^12, 
  (a*c*a*e*b*e)^12, (a*f*b*e*b*f)^12, (b*f*d*e*d*f)^12, (d*(f*e)^2*f)^12, 
  (a*b*f*b*a*c)^12, ((d*e)^2*d*f)^12, (a*f*d*e*d*f)^12, (b*e*(b*f)^2)^12, 
  (b*c*f*c*b*e)^12, (b*(e*c)^2*e)^12, (a*b*a*e*b*e)^12, (b*c*f*c*b*d)^12, 
  (a*c*a*f*b*f)^12, (b*d*c*d*b*f)^12, (b*d*c*f*c*d)^12, (a*b*a*e*f*e)^12, 
  (b*d*f*c*f*d)^12, (b*e*b*f*c*f)^12, (c*d*c*f*e*f)^12, (a*b*f*b*a*e)^12, 
  (a*b*f*e*f*b)^12, (a*b*(f*e)^2)^12, (a*c*a*d*e*d)^12, (b*e*d*e*b*f)^12, 
  (b*e*d*f*d*e)^12, (b*d*(b*e)^2)^12, (a*c*a*f*d*f)^12, (a*c*b*e*b*c)^12, 
  (a*b*e*b*c*e)^12, (a*b*e*f*e*b)^12, (a*b*(e*f)^2)^12, (a*d*c*d*a*e)^12, 
  (a*d*c*d*a*f)^12, (a*d*e*d*a*e)^12, ((c*d)^2*c*e)^12, (a*e*d*e*a*f)^12, 
  (c*e*d*f*d*e)^12, (a*f*d*c*d*f)^12, (b*d*e*b*e*d)^12, (a*f*e*b*e*f)^12, 
  (a*(f*e)^2*f)^12, (a*c*d*f*d*c)^12, (a*c*e*c*a*f)^12, (a*c*f*c*a*d)^12, 
  (b*(d*e)^2*d)^12, (c*e*d*e*c*f)^12, (c*d*e*d*c*e)^12, (b*e*f*e*d*f)^12, 
  ((c*e)^2*f*e)^12, (b*e*f*c*f*e)^12, ((b*d)^2*b*e)^12, (b*d*f*d*b*e)^12, 
  (b*e*f*b*f*e)^12, ((c*f)^2*d*f)^12, (b*f*e*d*e*f)^12, (b*e*f*d*f*e)^12, 
  (b*d*e*c*e*d)^12, ((b*f)^2*c*f)^12, (c*d*c*e*f*e)^12, (c*d*f*e*f*d)^12, 
  ((d*e)^2*f*e)^12, (a*b*f*b*c*b*e)^11, (a*b*f*c*b*c*e)^11, 
  (a*c*b*f*e*b*f)^11, (a*c*b*f*b*e*f)^11, (a*c*b*e*c*e*f)^11, 
  (a*c*b*f*e*c*e)^11, (a*(c*e)^2*b*f)^11, (a*b*c*b*f*a*e)^12, 
  (a*c*b*c*f*a*e)^12, (a*(d*f)^3)^12, 
  a*b*a*f*c*f*b*f*c*f*a*(b*a*f*c*b*a*c)^10*b*a*f, 
  a*b*a*(e*b*e*(a*b)^2)^11*(e*b)^2, a*c*a*(e*f*e*(a*c)^2)^11*e*f*e*c, 
  a*b*a*(d*f*d*(a*b)^2)^11*d*f*d*b, a*c*a*(d*f*d*(a*c)^2)^11*d*f*d*c, 
  a*c*a*(e*c*e*(a*c)^2)^11*(e*c)^2, a*c*a*(f*e*f*(a*c)^2)^11*f*e*f*c, 
  (c*d*(f*c)^2*f)^12, (b*c*(e*b)^2*f)^12, (b*c*f*c*e*f*e)^12, 
  ((a*d*f)^2*d)^12, ((a*d)^2*f*a*f)^12, (a*c*d*f*c*a*f)^12, ((c*e*f)^2*e)^12, 
  (a*b*a*d*b*d*f)^12, (a*d*b*f*d*a*f)^12, (a*d*f*a*e*f*e)^12, 
  (a*b*a*d*a*f*d)^12, (b*e*c*e*f*c*e)^12, a*b*c*a*b*c*(e*(c*b*a)^2)^11*e, 
  (b*c*d*f*c*b*f)^12, a*b*c*a*(e*(a*c*b)^2)^11*e*b*c, (a*b*(e*f)^2*c)^12, 
  (a*b*d*b*f*a*f)^12, (a*b*(f*e)^2*c)^12, (a*c*d*f*b*f*d)^12, 
  (a*b*f*d*f*a*f)^12, (b*d*(f*b)^2*f)^12, (a*d*f*a*f*b*f)^12, 
  (a*(b*d)^2*b*f)^12, (a*c*b*e*a*e*f)^12, (b*d*b*f*b*d*f)^12, 
  (a*b*(e*c)^2)^14, (a*c*d*c*f*c*d)^12, (b*c*e*f*e*b*f)^12, 
  (a*d*b*d*f*a*f)^12, (a*b*f*d*f*b*d)^12, (a*c*b*e*c*e)^14, 
  (a*b*f*(b*d)^2)^12, (a*c*e*(b*f)^2)^12, (a*b*d*b*f*d*f)^12, 
  (a*c*b*f*e*a*e)^12, (a*c*e*a*e*c*e)^12, (b*d*f*b*e*f*e)^12, 
  (a*b*(d*a)^2*f)^12, (a*c*e*a*e*b*f)^12, (a*d*b*f*b*d*f)^12, 
  (a*c*b*c*a*d)^15, (a*b*c*b*a*d)^15, (b*c*e*f*e)^18, (b*(f*e)^2*f)^15, 
  (a*c*a*e*f*c*f)^14, (a*c*e*f*c*f*e)^14, (a*b*f*a*f*b*f)^14, 
  (a*c*a*e*a*c*e)^14, (a*b*a*e*a*c*e)^14, (a*(c*e)^3)^14, (a*c*a*f*c*d*f)^14, 
  (a*c*e*b*d*b*e)^14, b*c*(d*f*b*c*b)^19*d*f*c, (c*b*c*d*f)^20, 
  (c*e*f*c*f)^20, (b*c*f*c*e*d*e)^15, (b*e*(f*c)^2*f)^15, (a*b*d*b*c*a*f)^15, 
  (a*b*c*f*c*d*c)^15, a*c*a*(f*e*(a*c)^2)^17*f*e*c, 
  a*c*a*(e*f*(a*c)^2)^17*e*f*c, (a*c*a*e*c*f)^18, (a*c*e*a*f*c)^18, 
  (a*c*e*a*c*f)^18, (a*c*a*d)^30, (a*d*b*d*f)^24, (a*b*a*f*c*f)^20, 
  (c*(d*f)^2*d)^20, (a*(d*c)^2*d)^20, (c*d*(c*f)^2)^20, (a*b*c*f*d*c)^20, 
  (a*b*f*c*f*d*c)^18, (a*b*e*f*a*f)^21, (b*e*c*e*b*e*f)^18, 
  (b*c*f*b*e*c*e)^18, (b*c*e*f*b*f*e)^18, (b*c*e*d*f*d*e)^18, (c*(d*f)^3)^20, 
  (a*b*e*b*a*e*f)^20, (b*c*f*c*b*e*f)^20, (a*b*d*f*b*a*f)^20, 
  (c*e*d*e*f*c*f)^20, (a*(c*f)^2*a*e)^20, (b*(d*e)^2*f*e)^20, 
  (a*e*c*f*e*a*f)^20, ((d*e*f)^2*e)^20, (b*e*(c*f)^2*e)^20, 
  ((d*e)^2*f*d*f)^20, (a*b*d*b*f*b*d)^20, (a*e*b*e*a*e*f)^20, 
  (a*b*c*f*a*b*f)^20, (b*(c*f)^2*e*f)^20, (b*e*c*f*e*b*f)^20, 
  (b*d*f*b*f*d*f)^20, (a*b*d*a*f*a*d)^20, (a*e*f*e*d*f)^24, (b*(d*c)^2*d)^24, 
  (a*f*d*b*d*f)^24, (a*(c*d)^2*c)^24, (a*b*f*e*a*f)^24, (a*b*c*e*a*c*e)^21, 
  a*c*a*(d*(a*c)^2)^29*d*c, (a*b*d*f*d)^30, (a*c*f*e*f)^30, (b*d*f*b*f)^30, 
  (a*b*e*f*e)^30, (a*c*a*d*f)^30, (b*e*d*f*e)^30, (a*b*e*b*c*a*f)^24, 
  (a*b*c*f*b*a*e)^24, (a*c*d*f*b*d)^28, (a*b*(a*d)^2*f)^24, 
  (a*d*(f*a)^2*f)^24, (a*(b*d)^2*f*b)^24, (a*b*f*d*c)^35, 
  a*c*a*(f*d*(a*c)^2)^29*f*d*c, a*c*a*(d*f*(a*c)^2)^29*d*f*c, 
  b*c*(e*f*b*c*b)^35*e*f*c, (c*b*c*e*f)^36, ((a*d)^2*c*d)^30, 
  ((b*d)^2*c*d)^30, (a*b*f*b*d*c)^30, (a*c*a*d*b*d)^30, (a*b*a*c*e*f*c)^28, 
  (a*b*d*b*a*c*f)^28, a*b*a*(d*c*d*(a*b)^2)^29*d*c*d*b, (a*(c*f)^2*c*d)^30, 
  (a*c*e*c*a*d*f)^30, (a*(b*f)^2*a*d)^30, ((c*e)^2*f*c*f)^30, 
  (a*c*a*e*f*a*f)^30, (b*(c*f)^2*b*e)^30, (b*c*f*c*e*b*f)^30, 
  a*b*c*a*b*c*(d*(c*b*a)^2)^29*d, (a*b*e*a*e*f*e)^30, (a*b*f*b*c*a*d)^30, 
  (a*b*e*f*b*f*e)^30, (a*b*e*a*e*b*e)^30, (a*b*c*a*f*d*c)^30, 
  (a*c*e*f*e*a*f)^30, (b*f*e*d*f*e*f)^30, (b*c*f*(c*e)^2)^30, 
  (a*c*e*f*d*f*e)^30, (a*b*(f*e)^2*f)^30, (a*b*c*f*a*d*c)^30, 
  (b*d*c*f*c*e*d)^30, (b*(c*d)^3)^30, (a*b*e*a*c*f*c)^30, (a*b*e*b*f*a*c)^30, 
  (a*b*a*d*c*d)^40, (a*c*b*f*b*d)^40, (a*c*d*f*c*b*f)^35, (b*c*f*b*f*e*f)^35, 
  (a*b*c*d*a*c*d)^35, (a*b*c*f*b*d*c)^35, (a*b*f*e*f*c)^42, (a*d*f*b*d*f)^42, 
  (a*b*(d*f)^2*c)^36, (a*c*b*d*f*d)^42, (a*b*c*d*f*d)^45, 
  b*c*(d*f*d*e*b*c*b)^39*d*f*d*e*c, (c*b*c*d*f*d*e)^40, 
  a*c*a*(d*b*d*(a*c)^2)^39*d*b*d*c, (c*d*f*d*e*f*e)^40, (a*b*d*f*d*a*f)^40, 
  (a*b*e*b*f*b*e)^40, (a*b*e*a*f*a*e)^40, ((a*e)^2*b*e*f)^40, 
  (b*f*e*c*f*e*f)^40, (a*c*f*c*d*c*f)^42, (a*c*e*(a*f)^2)^42, 
  (a*b*f*e*f*b*c)^42, (a*c*f*c*e*c*f)^42, (b*(e*c)^2*f*e)^42, 
  (a*b*d*c*d*b*c)^42, (a*c*f*e*b*e*f)^42, (a*c*d*a*f*c*f)^42, 
  (b*c*e*c*f*b*e)^42, (a*c*f*a*e*a*f)^42, (c*d*f*c*f)^60, 
  b*c*(e*(f*b)^2*c*b)^44*e*f*b*f*c, (c*b*c*e*f*b*f)^45, (a*c*e*d*f*d*e)^45, 
  (b*c*f*b*e)^63, (a*c*a*d*c*f)^56, (a*c*a*d*a*f)^56, (b*e*c*f*e)^70, 
  (b*d*b*f*c*f)^60, (a*c*a*d*c*d)^60, (c*d*(e*f)^2)^60, (a*b*d*b*a*c)^60, 
  (a*b*f*d*a*c)^60, (b*c*e*c*b*d)^60, (c*d*e*f*e*d)^60, (a*c*e*c*a*d)^60, 
  (a*e*f*e*b*f)^63, (a*c*e*b*f*d*e)^56, (a*c*f*b*e*b*f)^56, 
  (a*c*a*d*f*c*f)^56, (a*c*f*e*c*e*f)^56, a*c*a*(f*d*f*(a*c)^2)^59*f*d*f*c, 
  a*c*a*(d*c*d*(a*c)^2)^59*(d*c)^2, (d*e*d*f*d*e*f)^60, (b*d*c*d*f*c*d)^60, 
  (a*d*e*d*a*e*f)^60, (a*c*d*f*b*f)^70, (b*d*f*(b*e)^2)^60, (a*c*d*c*a*d)^70, 
  (a*(b*d)^2*f*d)^60, (c*e*d*f*e*c*f)^60, (b*e*d*f*e*b*f)^60, 
  (b*c*e*f*c*b*e)^60, (a*e*d*f*e*a*f)^60, (a*d*f*a*e*b*e)^60, 
  (c*e*c*f*c*e*f)^60, (c*d*e*d*f*c*e)^60, (a*b*e*d*f*d*e)^60, 
  (a*d*e*d*f*a*e)^60, ((b*d*f)^2*d)^60, (b*(f*c)^2*e*f)^60, 
  (a*c*e*b*d*f*d)^60, (c*d*f*d*e*c*f)^60, (a*c*d*f*b*c*d)^66, 
  (b*d*e*f*e*d*e)^70, (b*(e*f)^2*c*f)^70, (a*b*e*d*e*b*c)^70, 
  (a*c*f*a*e*b*e)^70, (b*d*c*e*f*c*d)^72, (a*c*f*e*f*b*f)^72, 
  (a*c*d*f*b*d*e)^77, (b*c*f*c*b*d*f)^84, (a*b*e*f*b*a*e)^84, 
  (a*c*b*d*f*d*e)^90, (a*c*b*e*d*f*d)^90, (a*b*c*f*a*d)^105, 
  (a*(c*d)^2*a*f)^99, (b*d*e*f*e*d)^120, (b*c*e*f*e*c*e)^105, 
  (a*b*f*c*b*d*c)^105, (b*d*e*c*f*e*d)^120, (a*b*e*b*f*a*e)^120, 
  (b*c*f*b*e*f*e)^120, (a*d*c*(f*e)^2)^126, (c*d*f*c*e*f*e)^140, 
  (b*c*d*c*e*b*f)^144, (a*c*e*d*f*b*e)^154, (a*c*e*d*f*b*d)^154, 
  ((c*d)^2*f*c*e)^210, (a*c*f*e*d*e*f)^210, (b*d*e*d*f*e*d)^210, 
  (a*b*d*e*f*e*d)^210, (a*c*a*d*c*d*f)^360, (b*c*d*c*b*d)^420, 
  (a*d*c*d*a*e*f)^420, (a*b*e*a*d*c*d)^728, (a*d*c*d*f*a*e)^840, 
  (a*c*a*d*e*d*f)^840, (a*c*a*d*e*f*d)^1260, (b*c*e*f*c*b*d)^1386 ];

H := F/rels;

CT23Z := CT([2,3],Integers);

phi := GroupHomomorphismByImagesNC(H,CT23Z);

return phi;

#############################################################################
##
#E  epifromfpgroupto_ct23z.g . . . . . . . . . . . . . . . . . . .  ends here
