/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSMathValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import org.w3c.css.om.typed.CSSUnitValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class NumericDelegateValue<D extends CSSMathValue>
extends NumericValue {
    private static final long serialVersionUID = 1L;
    private D delegate;

    protected NumericDelegateValue(D d) {
        this.delegate = d;
    }

    public String getCssText() {
        return this.delegate.getCssText();
    }

    @Override
    short getCSSUnit() {
        return this.delegate.computeUnitType();
    }

    public D getNumericDelegate() {
        return this.delegate;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        return this.delegate.matches(cSSValueSyntax);
    }

    public FloatValue evaluate(final CSSStylableElement cSSStylableElement, final String string, final CSSEngine cSSEngine, final int n, final StyleMap styleMap, final short s) throws DOMException {
        float f;
        short s2;
        Evaluator evaluator = new Evaluator(s){

            protected CSSTypedValue absoluteTypedValue(CSSTypedValue cSSTypedValue) {
                if (CSSUnit.isRelativeLengthUnitType((short)cSSTypedValue.getUnitType())) {
                    FloatValue floatValue = new FloatValue(cSSTypedValue.getUnitType(), cSSTypedValue.getFloatValue(cSSTypedValue.getUnitType()));
                    FloatValue floatValue2 = NumericDelegateValue.this.absoluteValue(cSSStylableElement, string, cSSEngine, n, styleMap, floatValue);
                    short s2 = floatValue2.getUnitType() != 0 ? floatValue2.getUnitType() : s;
                    return NumberValue.createCSSNumberValue((short)s2, (float)floatValue2.getFloatValue());
                }
                return cSSTypedValue;
            }

            protected float percentage(CSSTypedValue cSSTypedValue, short s2) throws DOMException {
                FloatValue floatValue = new FloatValue(cSSTypedValue.getUnitType(), cSSTypedValue.getFloatValue(cSSTypedValue.getUnitType()));
                FloatValue floatValue2 = NumericDelegateValue.this.absoluteValue(cSSStylableElement, string, cSSEngine, n, styleMap, floatValue);
                return NumberValue.floatValueConversion((float)floatValue2.getFloatValue(), (short)floatValue2.getUnitType(), (short)s2);
            }
        };
        CSSTypedValue cSSTypedValue = this.evaluate(evaluator);
        if (cSSTypedValue.getPrimitiveType() != CSSValue.Type.NUMERIC) {
            throw new DOMException(11, "Unexpected calc() result: " + cSSTypedValue.getCssText());
        }
        if (cSSTypedValue.getUnitType() == 0) {
            s2 = 0;
            f = cSSTypedValue.getFloatValue((short)0);
        } else {
            s2 = s;
            f = cSSTypedValue.getFloatValue(s);
        }
        return new FloatValue(s2, f);
    }

    protected abstract CSSTypedValue evaluate(Evaluator var1);

    protected FloatValue absoluteValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, FloatValue floatValue) throws DOMException {
        return floatValue;
    }

    public CSSUnitValue to(String string) {
        throw new DOMException(9, "Not supported.");
    }

    @Override
    public NumericDelegateValue<D> clone() {
        NumericDelegateValue numericDelegateValue = (NumericDelegateValue)super.clone();
        numericDelegateValue.delegate = this.delegate;
        return numericDelegateValue;
    }
}

