/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.AbstractCondition;
import io.sf.carte.doc.style.css.parser.MutableBoolean;
import java.util.Arrays;

class CombinatorConditionImpl
extends AbstractCondition
implements CombinatorCondition {
    private static final long serialVersionUID = 2L;
    AbstractCondition[] conditions;

    CombinatorConditionImpl() {
        this(2);
    }

    CombinatorConditionImpl(int size) {
        this.conditions = new AbstractCondition[size];
    }

    @Override
    public Condition.ConditionType getConditionType() {
        return Condition.ConditionType.AND;
    }

    @Override
    public AbstractCondition getFirstCondition() {
        return this.conditions[0];
    }

    @Override
    public AbstractCondition getSecondCondition() {
        return this.conditions[1];
    }

    public AbstractCondition getLastCondition() {
        return this.conditions[this.conditions.length - 1];
    }

    @Override
    public AbstractCondition getCondition(int index) {
        return this.conditions[index];
    }

    void setCondition(int idx, AbstractCondition newcond) {
        this.conditions[idx] = newcond;
    }

    @Override
    public int getLength() {
        return this.conditions.length;
    }

    CombinatorConditionImpl prependCondition(AbstractCondition cond) {
        int curlen = this.conditions.length;
        if (cond.getConditionType() == Condition.ConditionType.AND) {
            CombinatorConditionImpl comb = (CombinatorConditionImpl)cond;
            int otherlen = comb.conditions.length;
            AbstractCondition[] conds = new AbstractCondition[curlen + otherlen];
            System.arraycopy(comb.conditions, 0, conds, 0, otherlen);
            System.arraycopy(this.conditions, 0, conds, otherlen, curlen);
        } else {
            AbstractCondition[] conds = new AbstractCondition[curlen + 1];
            System.arraycopy(this.conditions, 0, conds, 1, curlen);
            conds[0] = cond;
            this.conditions = conds;
        }
        return this;
    }

    @Override
    CombinatorConditionImpl appendCondition(AbstractCondition cond) {
        int idx = this.conditions.length;
        if (cond.getConditionType() == Condition.ConditionType.AND) {
            CombinatorConditionImpl comb = (CombinatorConditionImpl)cond;
            int otherlen = comb.conditions.length;
            AbstractCondition[] conds = new AbstractCondition[idx + otherlen];
            System.arraycopy(this.conditions, 0, conds, 0, idx);
            System.arraycopy(comb.conditions, 0, conds, idx, otherlen);
        } else {
            AbstractCondition[] conds = new AbstractCondition[idx + 1];
            System.arraycopy(this.conditions, 0, conds, 0, idx);
            conds[idx] = cond;
            this.conditions = conds;
        }
        return this;
    }

    AbstractCondition removeFirstCondition() {
        int curlenm1 = this.conditions.length - 1;
        if (curlenm1 == 1) {
            return this.conditions[1];
        }
        AbstractCondition[] conds = new AbstractCondition[curlenm1];
        System.arraycopy(this.conditions, 1, conds, 0, curlenm1);
        this.conditions = conds;
        return this;
    }

    @Override
    AbstractCondition replace(SelectorList base, MutableBoolean replaced) {
        CombinatorConditionImpl clon = this.clone();
        for (int i = 0; i < this.conditions.length; ++i) {
            clon.conditions[i] = this.conditions[i].replace(base, replaced);
        }
        return clon;
    }

    public int hashCode() {
        int prime = 31;
        int result = Condition.ConditionType.AND.hashCode();
        result = 31 * result + Arrays.hashCode(this.conditions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CombinatorConditionImpl)) {
            return false;
        }
        CombinatorConditionImpl other = (CombinatorConditionImpl)obj;
        return Arrays.equals(this.conditions, other.conditions);
    }

    @Override
    void serialize(StringBuilder buf) {
        for (AbstractCondition cond : this.conditions) {
            if (cond == null) continue;
            cond.serialize(buf);
        }
    }

    @Override
    public CombinatorConditionImpl clone() {
        CombinatorConditionImpl clon = (CombinatorConditionImpl)super.clone();
        clon.conditions = (AbstractCondition[])this.conditions.clone();
        return clon;
    }
}

