/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface PasteIntoTargetMixin {
    default public boolean doHasEnoughSpace(Program program, Address address, int byteCount) {
        Address end;
        try {
            end = address.addNoWrap((long)(byteCount - 1));
        }
        catch (AddressOverflowException e) {
            return false;
        }
        AddressSet range = new AddressSet(address, end);
        return program.getMemory().intersect((AddressSetView)range).equals((Object)range);
    }

    default public boolean doPasteBytes(PluginTool tool, DebuggerControlService controlService, DebuggerConsoleService consoleService, DebuggerCoordinates current, ProgramLocation location, byte[] bytes) {
        Program program = location.getProgram();
        if (!(program instanceof TraceProgramView)) {
            tool.setStatusInfo("Not a trace?", true);
            return false;
        }
        TraceProgramView view = (TraceProgramView)program;
        DebuggerControlService.StateEditor editor = controlService.createStateEditor(current);
        try {
            editor.setVariable(location.getByteAddress(), bytes).get(1L, TimeUnit.SECONDS);
            return true;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (consoleService == null) {
                Msg.showError((Object)this, null, (String)"Paste Error", (Object)("Couldn't paste into " + String.valueOf(location.getProgram())), (Throwable)e);
            } else {
                consoleService.log(DebuggerResources.ICON_LOG_ERROR, "Couldn't paste into " + String.valueOf(view), (Throwable)e);
            }
            return false;
        }
    }
}

