/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import generic.lsh.vector.WeightFactory;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class WeightTable
extends SQLComplexTable {
    public WeightTable() {
        super("weighttable", "id");
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE weighttable(id integer,weight NUMERIC(24,20))");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        String sql = "DROP TABLE IF EXISTS " + this.tableName;
        st.executeUpdate(sql);
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 2) {
            throw new IllegalArgumentException("Insert method for WeightTable must take exactly two arguments: int and double");
        }
        Statement st = this.db.createStatement();
        int row = (Integer)arguments[0];
        double val = (Double)arguments[1];
        StringBuffer buf = new StringBuffer();
        buf.append("INSERT INTO weighttable (id,weight) VALUES(");
        buf.append(row).append(',').append(val).append(')');
        st.executeUpdate(buf.toString());
        return 0L;
    }

    public void recoverWeights(WeightFactory factory) throws SQLException {
        try (Statement st = this.db.createStatement();
             ResultSet rs = st.executeQuery("SELECT all * FROM weighttable");){
            double[] vals = new double[factory.getIDFSize() + factory.getTFSize() + 7];
            int numrows = 0;
            while (rs.next()) {
                double val;
                int id = rs.getInt(1);
                vals[id] = val = rs.getDouble(2);
                ++numrows;
            }
            if (numrows != factory.getIDFSize() + factory.getTFSize() + 7) {
                throw new SQLException("weighttable has wrong number of rows");
            }
            factory.set(vals);
        }
    }
}

