/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.app.plugin.core.compositeeditor.EditorListener;
import ghidra.app.plugin.core.compositeeditor.EditorProvider;
import ghidra.app.plugin.core.stackeditor.StackEditorManagerPlugin;
import ghidra.app.plugin.core.stackeditor.StackEditorProvider;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.HashMap;

public class StackEditorManager
implements EditorListener {
    private HashMap<Function, StackEditorProvider> editorMap;
    private StackEditorManagerPlugin plugin;

    public StackEditorManager(StackEditorManagerPlugin plugin) {
        this.plugin = plugin;
        this.editorMap = new HashMap();
    }

    public void dispose() {
        this.dismissEditors(null);
    }

    public void edit(Function function) {
        StackEditorProvider editor = this.editorMap.get(function);
        if (editor != null) {
            this.plugin.getTool().showComponentProvider(editor.getComponentProvider(), true);
        } else {
            editor = new StackEditorProvider(this.plugin, function);
            editor.addEditorListener(this);
            this.editorMap.put(function, editor);
        }
    }

    protected void programClosed(Program closedProgram) {
        this.dismissEditors(closedProgram);
    }

    boolean isEditInProgress() {
        return this.editorMap.size() > 0;
    }

    void dismissEditors(Program program) {
        ArrayList<Function> list = new ArrayList<Function>(this.editorMap.keySet());
        for (Function function : list) {
            if (program != null && function.getProgram() != program) continue;
            StackEditorProvider editor = this.editorMap.get(function);
            editor.dispose();
            this.editorMap.remove(function);
        }
    }

    private boolean checkEditors(Program program) {
        for (Function function : this.editorMap.keySet()) {
            if (program != null && function.getProgram() != program) continue;
            StackEditorProvider editor = this.editorMap.get(function);
            editor.show();
            if (!editor.needsSave() || editor.checkForSave(true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void closed(EditorProvider editor) {
        StackEditorProvider stackEditorProvider = (StackEditorProvider)editor;
        this.editorMap.remove(stackEditorProvider.getFunction());
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (!(dObj instanceof Program)) {
            return true;
        }
        return this.checkEditors((Program)dObj);
    }

    protected boolean canClose() {
        return this.checkEditors(null);
    }

    protected void close() {
        for (StackEditorProvider editor : this.editorMap.values()) {
            editor.dispose();
        }
        this.editorMap.clear();
    }
}

