/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.program.model.lang.Register;
import java.util.Collections;
import java.util.Map;

public class DWARFRegisterMappings {
    public static final DWARFRegisterMappings DUMMY = new DWARFRegisterMappings(Collections.emptyMap(), 0L, -1, false);
    private final Map<Integer, Register> dwarfRegisterMap;
    private final long callFrameCFA;
    private final int stackPointerIndex;
    private final boolean useFormalParameterStorage;

    public DWARFRegisterMappings(Map<Integer, Register> regmap, long callFrameCFA, int stackPointerIndex, boolean useFPS) {
        this.dwarfRegisterMap = regmap;
        this.callFrameCFA = callFrameCFA;
        this.stackPointerIndex = stackPointerIndex;
        this.useFormalParameterStorage = useFPS;
    }

    public Register getGhidraReg(int dwarfRegNum) {
        return this.dwarfRegisterMap.get(dwarfRegNum);
    }

    public long getCallFrameCFA() {
        return this.callFrameCFA;
    }

    public int getDWARFStackPointerRegNum() {
        return this.stackPointerIndex;
    }

    public boolean isUseFormalParameterStorage() {
        return this.useFormalParameterStorage;
    }

    public String toString() {
        return "DWARFRegisterMappings [dwarfRegisterMap=" + String.valueOf(this.dwarfRegisterMap) + ", callFrameCFA=" + this.callFrameCFA + ", stackPointerIndex=" + this.stackPointerIndex + ", useFormalParameterStorage=" + this.useFormalParameterStorage + "]";
    }
}

