/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface JitType {
    public static int compare(JitType t1, JitType t2) {
        int c = Integer.compare(t1.pref(), t2.pref());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(t1.size(), t2.size());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public static JitType forJavaType(Class<?> cls) {
        if (cls == Boolean.TYPE) {
            return IntJitType.I4;
        }
        if (cls == Byte.TYPE) {
            return IntJitType.I1;
        }
        if (cls == Short.TYPE) {
            return IntJitType.I2;
        }
        if (cls == Integer.TYPE) {
            return IntJitType.I4;
        }
        if (cls == Long.TYPE) {
            return LongJitType.I8;
        }
        if (cls == Float.TYPE) {
            return FloatJitType.F4;
        }
        if (cls == Double.TYPE) {
            return DoubleJitType.F8;
        }
        throw new IllegalArgumentException();
    }

    public int pref();

    public String nm();

    public int size();

    public JitType ext();

    public record IntJitType(int size) implements SimpleJitType
    {
        public static final IntJitType I1 = new IntJitType(1);
        public static final IntJitType I2 = new IntJitType(2);
        public static final IntJitType I3 = new IntJitType(3);
        public static final IntJitType I4 = new IntJitType(4);

        public IntJitType {
            assert (0 < size && size <= 4);
        }

        public static IntJitType forSize(int size) {
            return switch (size) {
                case 1 -> I1;
                case 2 -> I2;
                case 3 -> I3;
                case 4 -> I4;
                default -> throw new IllegalArgumentException("size:" + size);
            };
        }

        @Override
        public int pref() {
            return 0;
        }

        @Override
        public String nm() {
            return "i";
        }

        @Override
        public Class<?> javaType() {
            return Integer.TYPE;
        }

        @Override
        public int opcodeLoad() {
            return 21;
        }

        @Override
        public int opcodeStore() {
            return 54;
        }

        @Override
        public IntJitType ext() {
            return I4;
        }

        @Override
        public IntJitType asInt() {
            return this;
        }
    }

    public record LongJitType(int size) implements SimpleJitType
    {
        public static final LongJitType I5 = new LongJitType(5);
        public static final LongJitType I6 = new LongJitType(6);
        public static final LongJitType I7 = new LongJitType(7);
        public static final LongJitType I8 = new LongJitType(8);

        public LongJitType {
            assert (0 < size && size <= 8);
        }

        public static LongJitType forSize(int size) {
            return switch (size) {
                case 5 -> I5;
                case 6 -> I6;
                case 7 -> I7;
                case 8 -> I8;
                default -> throw new IllegalArgumentException("size:" + size);
            };
        }

        @Override
        public int pref() {
            return 1;
        }

        @Override
        public String nm() {
            return "l";
        }

        @Override
        public Class<?> javaType() {
            return Long.TYPE;
        }

        @Override
        public int opcodeLoad() {
            return 22;
        }

        @Override
        public int opcodeStore() {
            return 55;
        }

        @Override
        public LongJitType ext() {
            return I8;
        }

        @Override
        public LongJitType asInt() {
            return this;
        }
    }

    public static enum FloatJitType implements SimpleJitType
    {
        F4;


        @Override
        public int pref() {
            return 2;
        }

        @Override
        public String nm() {
            return "f";
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Class<?> javaType() {
            return Float.TYPE;
        }

        @Override
        public int opcodeLoad() {
            return 23;
        }

        @Override
        public int opcodeStore() {
            return 56;
        }

        @Override
        public FloatJitType ext() {
            return this;
        }

        @Override
        public IntJitType asInt() {
            return IntJitType.I4;
        }
    }

    public static enum DoubleJitType implements SimpleJitType
    {
        F8;


        @Override
        public int pref() {
            return 3;
        }

        @Override
        public String nm() {
            return "d";
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public Class<?> javaType() {
            return Double.TYPE;
        }

        @Override
        public int opcodeLoad() {
            return 24;
        }

        @Override
        public int opcodeStore() {
            return 57;
        }

        @Override
        public DoubleJitType ext() {
            return this;
        }

        @Override
        public LongJitType asInt() {
            return LongJitType.I8;
        }
    }

    public record MpFloatJitType(int size) implements JitType
    {
        private static final Map<Integer, MpFloatJitType> FOR_SIZES = new HashMap<Integer, MpFloatJitType>();

        public static MpFloatJitType forSize(int size) {
            return FOR_SIZES.computeIfAbsent(size, MpFloatJitType::new);
        }

        @Override
        public int pref() {
            return 5;
        }

        @Override
        public String nm() {
            return "F";
        }

        @Override
        public MpFloatJitType ext() {
            return this;
        }
    }

    public record MpIntJitType(int size) implements JitType
    {
        private static final Map<Integer, MpIntJitType> FOR_SIZES = new HashMap<Integer, MpIntJitType>();

        public static MpIntJitType forSize(int size) {
            return FOR_SIZES.computeIfAbsent(size, MpIntJitType::new);
        }

        @Override
        public int pref() {
            return 4;
        }

        @Override
        public String nm() {
            return "I";
        }

        public int legsAlloc() {
            return (this.size + 4 - 1) / 4;
        }

        public int legsWhole() {
            return this.size / 4;
        }

        public int partialSize() {
            return this.size % 4;
        }

        public List<SimpleJitType> legTypes() {
            IntJitType[] types = new IntJitType[this.legsAlloc()];
            int i = 0;
            if (this.partialSize() != 0) {
                types[i++] = IntJitType.forSize(this.partialSize());
            }
            while (i < this.legsWhole()) {
                types[i] = IntJitType.I4;
                ++i;
            }
            return Arrays.asList(types);
        }

        @Override
        public MpIntJitType ext() {
            return MpIntJitType.forSize(this.legsAlloc() * 4);
        }
    }

    public static interface SimpleJitType
    extends JitType {
        public Class<?> javaType();

        public int opcodeLoad();

        public int opcodeStore();

        public SimpleJitType asInt();
    }
}

