/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatclass;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.oat.oatclass.OatClass;
import ghidra.file.formats.android.oat.oatclass.OatClassType;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsets;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsetsFactory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatClass_S_T
extends OatClass {
    public static final int kWordBytes = 4;
    private int num_methods_;
    private byte[] bitmap_ = new byte[0];

    OatClass_S_T(BinaryReader reader, ClassDataItem classDataItem, String oatVersion) throws IOException {
        super(reader, oatVersion);
        int i;
        this.type_ = reader.readNextShort();
        if (this.type_ == OatClassType.kOatClassNoneCompiled.ordinal()) {
            return;
        }
        this.num_methods_ = reader.readNextInt();
        int methodOffsetsCount = 0;
        if (this.type_ == OatClassType.kOatClassSomeCompiled.ordinal()) {
            this.bitmap_ = reader.readNextByteArray(this.getBitmapSize());
            for (i = 0; i < this.bitmap_.length; ++i) {
                methodOffsetsCount += Integer.bitCount(Byte.toUnsignedInt(this.bitmap_[i]));
            }
        } else if (this.type_ == OatClassType.kOatClassAllCompiled.ordinal()) {
            methodOffsetsCount = classDataItem.getDirectMethodsSize() + classDataItem.getVirtualMethodsSize();
        }
        for (i = 0; i < methodOffsetsCount; ++i) {
            this.methods_pointer_.add(OatMethodOffsetsFactory.getOatMethodOffsets(reader, oatVersion));
        }
    }

    public int getNumMethods() {
        return this.num_methods_;
    }

    public byte[] getBitmap() {
        return this.bitmap_;
    }

    @Override
    public boolean isMethodNative(int methodIndex) {
        int bytePos = methodIndex / 8;
        int bitPos = methodIndex % 8;
        return (this.bitmap_[bytePos] >> bitPos & 1) == 1;
    }

    private int getBitmapSize() {
        if (this.num_methods_ == 0) {
            return 0;
        }
        int size = (int)NumericUtilities.getUnsignedAlignedValue((long)this.num_methods_, (long)32L);
        return size / 8;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        Object className = OatClass_S_T.class.getSimpleName();
        if (this.methods_pointer_.size() > 0) {
            className = (String)className + "_" + this.methods_pointer_.size();
        }
        if (this.bitmap_.length > 0) {
            className = (String)className + "_" + this.bitmap_.length;
        }
        StructureDataType structure = new StructureDataType((String)className, 0);
        structure.add(this.statusEnum.toDataType(), "status_", null);
        structure.add(OatClassType.toData(), "type", null);
        if (this.type_ != OatClassType.kOatClassNoneCompiled.ordinal()) {
            structure.add(DWORD, "num_methods_", null);
            if (this.type_ == OatClassType.kOatClassSomeCompiled.ordinal() && this.bitmap_.length > 0) {
                ArrayDataType bitmapDataType = new ArrayDataType(BYTE, this.bitmap_.length, BYTE.getLength());
                structure.add((DataType)bitmapDataType, "bitmap", null);
            }
            for (int i = 0; i < this.methods_pointer_.size(); ++i) {
                structure.add(((OatMethodOffsets)this.methods_pointer_.get(i)).toDataType(), "methods_pointer_" + i, null);
            }
        }
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

