/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.prelink;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import ghidra.file.formats.ios.prelink.GFileSystemLoadKernelTask;
import ghidra.file.formats.ios.prelink.MachoPrelinkFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.util.ArrayList;
import java.util.List;

public class MachoPrelinkFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Load iOS Kernel", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> {
            if (ac.isBusy() || ac.getSelectedNode() == null) {
                return false;
            }
            FSBRootNode rootNode = ac.getSelectedNode().getFSBRootNode();
            return rootNode != null && rootNode.getFSRef() != null && rootNode.getFSRef().getFilesystem() instanceof MachoPrelinkFileSystem;
        }).popupMenuPath(new String[]{"Load iOS Kernel"}).popupMenuIcon(FSBIcons.iOS).popupMenuGroup("I").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            ArrayList<FSRL> fileList = new ArrayList<FSRL>();
            if (fsrl != null) {
                FSBNode selectedNode = ac.getSelectedNode();
                if (selectedNode instanceof FSBRootNode) {
                    for (GTreeNode childNode : ac.getSelectedNode().getChildren()) {
                        if (!(childNode instanceof FSBNode)) continue;
                        FSBNode baseNode = (FSBNode)childNode;
                        fileList.add(baseNode.getFSRL());
                    }
                } else if (selectedNode instanceof FSBFileNode || selectedNode instanceof FSBDirNode) {
                    fileList.add(fsrl);
                }
            }
            if (!fileList.isEmpty()) {
                if (OptionDialog.showYesNoDialog(null, (String)"Load iOS Kernel?", (String)"Performing this action will load the entire kernel and all KEXT files.\nDo you want to continue?") == 1) {
                    this.loadIOSKernel(fileList);
                }
            } else {
                ac.getComponentProvider().getPlugin().getTool().setStatusInfo("Load iOS kernel -- nothing to do.");
            }
        }).build());
    }

    private void loadIOSKernel(List<FSRL> fileList) {
        FileSystemBrowserPlugin fsbPlugin = this.context.plugin();
        OpenWithTarget openWith = OpenWithTarget.getRunningProgramManager((PluginTool)fsbPlugin.getTool());
        if (openWith.getPm() != null) {
            TaskLauncher.launch((Task)new GFileSystemLoadKernelTask((Plugin)fsbPlugin, openWith.getPm(), fileList));
        }
    }
}

