/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zlib;

import ghidra.app.util.bin.ByteProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZLIB {
    public static final byte[] ZLIB_COMPRESSION_BEST = new byte[]{120, -38};
    public static final byte[] ZLIB_COMPRESSION_DEFAULT = new byte[]{120, -100};
    public static final byte[] ZLIB_COMPRESSION_NO_LOW = new byte[]{120, 1};

    public ByteArrayOutputStream decompress(InputStream compressedIn, int expectedDecompressedLength) throws IOException {
        return this.decompress(compressedIn, expectedDecompressedLength, false);
    }

    public ByteArrayOutputStream decompress(InputStream compressedIn, int expectedDecompressedLength, boolean noWrap) throws IOException {
        byte[] compressedBytes = this.convertInputStreamToByteArray(compressedIn);
        ByteArrayOutputStream decompressedBOS = new ByteArrayOutputStream();
        byte[] tempDecompressedBytes = new byte[65536];
        int totalDecompressed = 0;
        try {
            Inflater inflater;
            int nDecompressed;
            for (int offset = 0; offset < compressedBytes.length && totalDecompressed < expectedDecompressedLength && (noWrap || compressedBytes[offset] == 120); totalDecompressed += nDecompressed, offset += inflater.getTotalIn()) {
                inflater = new Inflater(noWrap);
                inflater.setInput(compressedBytes, offset, compressedBytes.length - offset);
                nDecompressed = inflater.inflate(tempDecompressedBytes);
                if (nDecompressed != 0) {
                    decompressedBOS.write(tempDecompressedBytes, 0, nDecompressed);
                    continue;
                }
                break;
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage());
        }
        return decompressedBOS;
    }

    private byte[] convertInputStreamToByteArray(InputStream compressedIn) throws IOException {
        int nRead;
        byte[] bytes = new byte[8096];
        ByteArrayOutputStream compressedBOS = new ByteArrayOutputStream();
        while ((nRead = compressedIn.read(bytes)) != -1) {
            compressedBOS.write(bytes, 0, nRead);
        }
        return compressedBOS.toByteArray();
    }

    public ByteArrayOutputStream compress(byte[] decompressedBytes) throws IOException {
        return this.compress(false, decompressedBytes);
    }

    public ByteArrayOutputStream compress(boolean noWrap, byte[] decompressedBytes) throws IOException {
        Deflater deflater;
        ByteArrayOutputStream compressedBOS = new ByteArrayOutputStream();
        byte[] tempBuffer = new byte[65536];
        for (int offset = 0; offset < decompressedBytes.length; offset += deflater.getTotalIn()) {
            int nDeflated;
            deflater = new Deflater(0, noWrap);
            deflater.setInput(decompressedBytes, offset, decompressedBytes.length - offset);
            deflater.finish();
            if (deflater.needsInput()) {
                System.out.println("needs input??");
            }
            if ((nDeflated = deflater.deflate(tempBuffer)) == 0) break;
            compressedBOS.write(tempBuffer, 0, nDeflated);
        }
        return compressedBOS;
    }

    public static final boolean isZLIB(ByteProvider provider) {
        try {
            byte[] bytes = provider.readBytes(0L, 2L);
            if (Arrays.equals(bytes, ZLIB_COMPRESSION_NO_LOW)) {
                return true;
            }
            if (Arrays.equals(bytes, ZLIB_COMPRESSION_DEFAULT)) {
                return true;
            }
            if (Arrays.equals(bytes, ZLIB_COMPRESSION_BEST)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

