/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.RenameStructFieldTask;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.app.plugin.core.decompile.actions.RenameUnionFieldTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class RenameFieldAction
extends AbstractDecompilerAction {
    public RenameFieldAction() {
        super("Rename Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameField"));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Field"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        return tokenAtCursor instanceof ClangFieldToken;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Composite dt = RenameFieldAction.getCompositeDataType(tokenAtCursor);
        if (dt == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Rename Failed", (Object)"Could not find structure datatype");
            return;
        }
        int offset = ((ClangFieldToken)tokenAtCursor).getOffset();
        if (offset < 0 || offset >= dt.getLength()) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Rename Failed", (Object)"Could not resolve field within structure");
            return;
        }
        RenameTask nameTask = dt instanceof Structure ? new RenameStructFieldTask(tool, context.getProgram(), context.getComponentProvider(), tokenAtCursor, (Structure)dt, offset) : new RenameUnionFieldTask(tool, context.getProgram(), context.getComponentProvider(), tokenAtCursor, dt, offset);
        nameTask.runTask(true);
    }
}

