/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationLayoutAlgorithm<V>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(AnimationLayoutAlgorithm.class);
    protected boolean done = false;
    protected int count = 20;
    protected int counter = 0;
    protected Runnable after = () -> {};
    LayoutModel<V> transitionLayoutModel;
    VisualizationServer<V, ?> visualizationServer;
    LayoutAlgorithm<V> endLayoutAlgorithm;
    LayoutModel<V> layoutModel;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public AnimationLayoutAlgorithm() {
        this(AnimationLayoutAlgorithm.builder());
    }

    protected AnimationLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        this.visualizationServer = builder.visualizationServer;
        this.endLayoutAlgorithm = builder.endLayoutAlgorithm;
        this.endLayoutAlgorithm.setAfter(builder.after);
        this.after = builder.after;
    }

    public void visit(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.layoutModel = layoutModel;
        this.transitionLayoutModel = ((LayoutModel.Builder)LayoutModel.builder().graph(this.visualizationServer.getVisualizationModel().getGraph())).layoutModel(layoutModel).initializer(layoutModel).build();
        this.transitionLayoutModel.accept(this.endLayoutAlgorithm);
    }

    public void step() {
        for (Object v : this.layoutModel.getGraph().vertexSet()) {
            Point tp = (Point)this.layoutModel.apply(v);
            Point fp = (Point)this.transitionLayoutModel.apply(v);
            double dx = (fp.x - tp.x) / (double)(this.count - this.counter);
            double dy = (fp.y - tp.y) / (double)(this.count - this.counter);
            log.trace("dx:{},dy:{}", (Object)dx, (Object)dy);
            this.layoutModel.set(v, tp.x + dx, tp.y + dy);
        }
        ++this.counter;
        if (this.counter >= this.count) {
            this.done = true;
            this.transitionLayoutModel.stop();
            this.visualizationServer.getVisualizationModel().setLayoutAlgorithm(this.endLayoutAlgorithm);
        }
    }

    public boolean done() {
        if (this.cancelled) {
            return true;
        }
        if (this.done) {
            this.after.run();
        }
        return this.done;
    }

    public static class Builder<V, T extends AnimationLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected VisualizationServer<V, ?> visualizationServer;
        protected LayoutAlgorithm<V> endLayoutAlgorithm;
        protected Runnable after = () -> {};

        public B visualizationServer(VisualizationServer<V, ?> visualizationServer) {
            this.visualizationServer = visualizationServer;
            return (B)((Object)((Builder)this.self()));
        }

        public B endLayoutAlgorithm(LayoutAlgorithm<V> endLayoutAlgorithm) {
            this.endLayoutAlgorithm = endLayoutAlgorithm;
            return (B)((Object)((Builder)this.self()));
        }

        public B after(Runnable after) {
            this.after = after;
            return (B)((Object)((Builder)this.self()));
        }

        public T build() {
            return (T)((Object)new AnimationLayoutAlgorithm(this));
        }
    }
}

