/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DomainObjectChangeSupport;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.EventType;
import ghidra.util.Lock;
import java.lang.ref.Cleaner;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class DomainObjectEventQueues {
    protected final DomainObject source;
    protected final Lock lock;
    protected final DomainObjectChangeSupport eventQueue;
    protected final Map<EventQueueID, PrivateQueue> privateEventQueues = new WeakHashMap<EventQueueID, PrivateQueue>();
    protected volatile boolean eventsEnabled = true;

    public DomainObjectEventQueues(DomainObject source, int timeInterval, Lock lock) {
        this.source = source;
        this.lock = lock;
        this.eventQueue = new DomainObjectChangeSupport(source, timeInterval, lock);
    }

    public void flushEvents() {
        this.eventQueue.flush();
        for (PrivateQueue privateQueue : this.privateEventQueues.values()) {
            privateQueue.flush();
        }
    }

    public void addListener(DomainObjectListener l) {
        this.eventQueue.addListener(l);
    }

    public void removeListener(DomainObjectListener l) {
        this.eventQueue.removeListener(l);
    }

    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        EventQueueID id = new EventQueueID();
        DomainObjectChangeSupport docs = new DomainObjectChangeSupport(this.source, maxDelay, this.lock);
        docs.addListener(listener);
        this.privateEventQueues.put(id, new PrivateQueue(docs));
        return id;
    }

    public boolean removePrivateEventQueue(EventQueueID id) {
        PrivateQueue privateQueue = this.privateEventQueues.remove(id);
        if (privateQueue == null) {
            return false;
        }
        privateQueue.cleanable.clean();
        return true;
    }

    public void flushPrivateEventQueue(EventQueueID id) {
        PrivateQueue privateQueue = this.privateEventQueues.get(id);
        if (privateQueue == null) {
            throw new NoSuchElementException("Private queue no longer exists");
        }
        privateQueue.flush();
    }

    public void fireEvent(DomainObjectChangeRecord ev) {
        if (this.eventsEnabled) {
            this.eventQueue.fireEvent(ev);
            for (PrivateQueue privateQueue : this.privateEventQueues.values()) {
                privateQueue.fireEvent(ev);
            }
        }
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        if (this.eventsEnabled == eventsEnabled) {
            return;
        }
        this.eventsEnabled = eventsEnabled;
        if (eventsEnabled) {
            DomainObjectChangeRecord restored = new DomainObjectChangeRecord((EventType)DomainObjectEvent.RESTORED);
            this.eventQueue.fireEvent(restored);
            for (PrivateQueue privateQueue : this.privateEventQueues.values()) {
                privateQueue.fireEvent(restored);
            }
        }
    }

    public boolean isSendingEvents() {
        return this.eventsEnabled;
    }

    protected static class PrivateQueue {
        private static final Cleaner CLEANER = Cleaner.create();
        private final State state;
        private final Cleaner.Cleanable cleanable;

        public PrivateQueue(DomainObjectChangeSupport docs) {
            this.state = new State(docs);
            this.cleanable = CLEANER.register(this, this.state);
        }

        public void flush() {
            this.state.docs.flush();
        }

        public void fireEvent(DomainObjectChangeRecord ev) {
            this.state.docs.fireEvent(ev);
        }

        static class State
        implements Runnable {
            final DomainObjectChangeSupport docs;

            public State(DomainObjectChangeSupport docs) {
                this.docs = docs;
            }

            @Override
            public void run() {
                this.docs.dispose();
            }
        }
    }
}

