/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.DecisionNode;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class SubtableSymbol
extends TripleSymbol {
    private Constructor[] construct;
    private DecisionNode decisiontree;

    public DecisionNode getDecisionNode() {
        return this.decisiontree;
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        return this.decisiontree.resolve(walker, debug);
    }

    public int getNumConstructors() {
        return this.construct.length;
    }

    public Constructor getConstructor(int i) {
        return this.construct[i];
    }

    @Override
    public PatternExpression getPatternExpression() {
        throw new SleighException("Cannot use subtable in expression");
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        throw new SleighException("Cannot use subtable in expression");
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        throw new SleighException("Cannot use subtable in expression");
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) {
        throw new SleighException("Cannot use subtable in expression");
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        int numct = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_NUMCT);
        this.construct = new Constructor[numct];
        for (int i = 0; i < numct; ++i) {
            Constructor ct = new Constructor();
            ct.setId(i);
            this.construct[i] = ct;
            ct.decode(decoder, sleigh);
        }
        if (decoder.peekElement() != 0) {
            this.decisiontree = new DecisionNode();
            this.decisiontree.decode(decoder, null, this);
        }
        decoder.closeElement(SlaFormat.ELEM_SUBTABLE_SYM.id());
    }
}

