/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import com.google.common.base.Predicate;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.SettingDB;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.Msg;

class DataTypeSettingsDB
implements Settings {
    private final DataTypeManagerDB dataMgr;
    private final long dataTypeID;
    private final DataType dataType;
    private boolean locked;
    private Predicate<String> allowedSettingPredicate;
    private Settings defaultSettings;

    DataTypeSettingsDB(DataTypeManagerDB dataMgr, BuiltInDataType dataType, long dataTypeID) {
        this.dataMgr = dataMgr;
        this.dataType = dataType;
        this.dataTypeID = dataTypeID;
        this.locked = !(dataMgr instanceof ProgramBasedDataTypeManager);
    }

    DataTypeSettingsDB(DataTypeManagerDB dataMgr, DataTypeDB dataType, long dataTypeID) {
        this.dataMgr = dataMgr;
        this.dataType = dataType;
        this.dataTypeID = dataTypeID;
        this.locked = !(dataMgr instanceof ProgramBasedDataTypeManager);
    }

    boolean setLock(boolean lock) {
        boolean wasLocked = this.locked;
        this.locked = lock;
        return wasLocked;
    }

    public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
        if (this.locked) {
            return false;
        }
        return this.allowedSettingPredicate == null || this.allowedSettingPredicate.apply((Object)settingsDefinition.getStorageKey());
    }

    public String[] getSuggestedValues(StringSettingsDefinition settingsDefinition) {
        return this.dataMgr.getSuggestedValues(settingsDefinition);
    }

    void setAllowedSettingPredicate(Predicate<String> allowedSettingPredicate) {
        this.allowedSettingPredicate = allowedSettingPredicate;
    }

    private boolean checkSetting(String type, String name) {
        if (!this.checkImmutableSetting(type, name)) {
            return false;
        }
        if (name != null && this.allowedSettingPredicate != null && !this.allowedSettingPredicate.apply((Object)name)) {
            Msg.warn((Object)this, (Object)("Ignored disallowed setting '" + name + "'"));
            return false;
        }
        return true;
    }

    private boolean checkImmutableSetting(String type, String name) {
        if (this.locked) {
            Object typeStr = "";
            if (type != null) {
                typeStr = type + " ";
            }
            Object nameStr = ": " + name;
            if (name == null) {
                nameStr = "s";
            }
            Msg.warn(SettingsImpl.class, (Object)("Ignored invalid attempt to modify immutable " + (String)typeStr + "component setting" + (String)nameStr));
            return false;
        }
        return true;
    }

    private void settingsChanged() {
        this.dataMgr.dataTypeSettingsChanged(this.dataType);
    }

    public Long getLong(String name) {
        SettingDB settingDB = this.dataMgr.getSetting(this.dataTypeID, name);
        if (settingDB != null) {
            return settingDB.getLongValue();
        }
        if (this.defaultSettings != null) {
            return this.defaultSettings.getLong(name);
        }
        return null;
    }

    public String getString(String name) {
        SettingDB settingDB = this.dataMgr.getSetting(this.dataTypeID, name);
        if (settingDB != null) {
            return settingDB.getStringValue();
        }
        if (this.defaultSettings != null) {
            return this.defaultSettings.getString(name);
        }
        return null;
    }

    public Object getValue(String name) {
        SettingDB settingDB = this.dataMgr.getSetting(this.dataTypeID, name);
        if (settingDB != null) {
            return settingDB.getValue();
        }
        if (this.defaultSettings != null) {
            return this.defaultSettings.getValue(name);
        }
        return null;
    }

    public void setLong(String name, long value) {
        if (this.checkSetting("long", name) && this.dataMgr.updateSettingsRecord(this.dataTypeID, name, null, value)) {
            this.settingsChanged();
        }
    }

    public void setString(String name, String value) {
        if (this.checkSetting("string", name) && this.dataMgr.updateSettingsRecord(this.dataTypeID, name, value, -1L)) {
            this.settingsChanged();
        }
    }

    public void setValue(String name, Object value) {
        if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else {
            throw new IllegalArgumentException("Value is not a known settings type: " + name);
        }
    }

    public void clearSetting(String name) {
        if (this.checkImmutableSetting(null, name) && this.dataMgr.clearSetting(this.dataTypeID, name)) {
            this.settingsChanged();
        }
    }

    public void clearAllSettings() {
        if (this.checkImmutableSetting(null, null) && this.dataMgr.clearAllSettings(this.dataTypeID)) {
            this.settingsChanged();
        }
    }

    public String[] getNames() {
        return this.dataMgr.getSettingsNames(this.dataTypeID);
    }

    public boolean isEmpty() {
        return this.getNames().length == 0;
    }

    public void setDefaultSettings(Settings settings) {
        this.defaultSettings = settings;
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

