/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeTask;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class GTreeBulkTask
extends GTreeTask {
    protected GTreeBulkTask(GTree tree) {
        super(tree);
    }

    public final void run(TaskMonitor monitor) throws CancelledException {
        boolean filteringEnabled = this.tree.isFilteringEnabled();
        try {
            if (filteringEnabled) {
                this.enableFilter(false);
            }
            this.runBulk(monitor);
        }
        finally {
            if (filteringEnabled) {
                this.enableFilter(true);
            }
        }
    }

    private void enableFilter(final boolean enable) {
        SystemUtilities.runSwingNow((Runnable)new Runnable(){

            @Override
            public void run() {
                GTreeBulkTask.this.tree.setFilteringEnabled(enable);
            }
        });
    }

    public abstract void runBulk(TaskMonitor var1) throws CancelledException;
}

