/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.WeightFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class HashEntry {
    private int hash;
    private short tf;
    private short idf;
    private double coeff;

    public HashEntry() {
    }

    public HashEntry(int h, int tcnt, double weight) {
        this.hash = h;
        this.tf = (short)(tcnt > 63 ? 63 : tcnt - 1);
        this.idf = 1;
        this.coeff = weight;
    }

    public HashEntry(int h, int tcnt, int dcnt, WeightFactory w) {
        this.hash = h;
        this.tf = (short)(tcnt > 63 ? 63 : tcnt - 1);
        this.idf = (short)(dcnt > 511 ? 511 : dcnt);
        this.coeff = w.getCoeff(this.idf, this.tf);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hash;
        result = 31 * result + this.tf;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashEntry)) {
            return false;
        }
        HashEntry other = (HashEntry)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return this.tf == other.tf;
    }

    public int getHash() {
        return this.hash;
    }

    public short getTF() {
        return (short)(this.tf + 1);
    }

    public short getIDF() {
        return this.idf;
    }

    public double getCoeff() {
        return this.coeff;
    }

    public void saveXml(Writer fwrite) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(" <hash");
        if (this.tf != 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute(buf, "tf", this.tf + 1);
        }
        buf.append('>');
        buf.append(SpecXmlUtils.encodeUnsignedInteger((long)this.hash & 0xFFFFFFFFL));
        buf.append("</hash>\n");
        fwrite.append(buf.toString());
    }

    public void saveSQL(StringBuilder buf) {
        buf.append(Integer.toHexString(this.tf + 1));
        buf.append(':');
        buf.append(Integer.toHexString(this.hash));
    }

    public void restoreXml(XmlPullParser parser, WeightFactory w) {
        this.tf = 0;
        this.idf = 0;
        XmlElement el = parser.start(new String[]{"hash"});
        String str = el.getAttribute("tf");
        if (str != null) {
            this.tf = (short)SpecXmlUtils.decodeInt(str);
            this.tf = (short)(this.tf - 1);
        }
        if ((str = el.getAttribute("idf")) != null) {
            this.idf = (short)SpecXmlUtils.decodeInt(str);
        }
        this.hash = SpecXmlUtils.decodeInt(parser.end().getText());
        this.coeff = w.getCoeff(this.idf, this.tf);
    }

    public void restoreXml(XmlPullParser parser, WeightFactory w, IDFLookup lookup) {
        this.tf = 0;
        XmlElement el = parser.start(new String[]{"hash"});
        String str = el.getAttribute("tf");
        if (str != null) {
            this.tf = (short)SpecXmlUtils.decodeInt(str);
            this.tf = (short)(this.tf - 1);
        }
        this.hash = SpecXmlUtils.decodeInt(parser.end().getText());
        this.idf = (short)lookup.getCount(this.hash);
        this.coeff = w.getCoeff(this.idf, this.tf);
    }

    private int parseHash(String sql, int start) throws IOException {
        this.hash = 0;
        while (true) {
            if (start >= sql.length()) {
                throw new IOException("Parsing hashentry with no terminator");
            }
            char tok = sql.charAt(start);
            if (tok < '0') {
                return start;
            }
            if (tok <= '9') {
                this.hash <<= 4;
                this.hash += tok - 48;
            } else {
                if (tok < 'A') {
                    return start;
                }
                if (tok <= 'F') {
                    this.hash <<= 4;
                    this.hash += tok - 65 + 10;
                } else {
                    if (tok < 'a') {
                        return start;
                    }
                    if (tok <= 'f') {
                        this.hash <<= 4;
                        this.hash += tok - 97 + 10;
                    } else {
                        return start;
                    }
                }
            }
            ++start;
        }
    }

    public int restoreSQL(String sql, int start, WeightFactory w, IDFLookup lookup) throws IOException {
        this.hash = 0;
        start = this.parseHash(sql, start);
        if (this.hash == 0 || sql.charAt(start) != ':') {
            throw new IOException("Error parsing HashEntry");
        }
        this.tf = (short)(this.hash - 1);
        start = this.parseHash(sql, start + 1);
        this.idf = (short)lookup.getCount(this.hash);
        this.coeff = w.getCoeff(this.idf, this.tf);
        return start;
    }

    public boolean restoreBase64(char[] buffer, int offset, int[] decoder, WeightFactory w, IDFLookup lookup) {
        this.tf = (short)decoder[buffer[offset]];
        if (this.tf < 0) {
            return false;
        }
        int val = decoder[buffer[offset + 1]];
        val <<= 6;
        val |= decoder[buffer[offset + 2]];
        val <<= 6;
        val |= decoder[buffer[offset + 3]];
        val <<= 6;
        val |= decoder[buffer[offset + 4]];
        val <<= 6;
        if ((val |= decoder[buffer[offset + 5]]) < 0) {
            return false;
        }
        int rem1 = decoder[buffer[offset + 6]];
        this.hash = (val <<= 2) | rem1 & 3;
        if (rem1 > 3) {
            return false;
        }
        this.idf = (short)lookup.getCount(this.hash);
        this.coeff = w.getCoeff(this.idf, this.tf);
        return true;
    }

    public void saveBase64(char[] buffer, int offset, char[] encoder) {
        buffer[offset] = encoder[this.tf];
        int val = this.hash;
        buffer[offset + 6] = encoder[val & 3];
        buffer[offset + 5] = encoder[(val >>>= 2) & 0x3F];
        buffer[offset + 4] = encoder[(val >>>= 6) & 0x3F];
        buffer[offset + 3] = encoder[(val >>>= 6) & 0x3F];
        buffer[offset + 2] = encoder[(val >>>= 6) & 0x3F];
        buffer[offset + 1] = encoder[(val >>>= 6) & 0x3F];
    }
}

