/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.btree;

import java.io.IOException;
import mobiledevices.dmg.btree.BTreeNodeDescriptor;
import mobiledevices.dmg.decmpfs.DecmpfsHeader;
import mobiledevices.dmg.ghidra.GBinaryReader;

public class BTreeNodeRecord {
    private int unknown0;
    private int fileID;
    private int unknown2;
    private String type;
    private int unknown3;
    private int unknown4;
    private int unknown5;
    private int recordLength;
    private short _typeLength;
    private BTreeNodeDescriptor _descriptor;
    private DecmpfsHeader _decmpfsHeader;
    private long _offset;

    BTreeNodeRecord(GBinaryReader reader, BTreeNodeDescriptor descriptor) throws IOException {
        this._offset = reader.getPointerIndex();
        this.unknown0 = reader.readNextInt();
        this.fileID = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this._typeLength = reader.readNextShort();
        this.type = this.readType(reader);
        this.unknown3 = reader.readNextInt();
        switch (descriptor.getKind()) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case -1: {
                this.unknown4 = reader.readNextInt();
                this.unknown5 = reader.readNextInt();
                this.recordLength = reader.readNextInt();
                break;
            }
        }
        this._descriptor = descriptor;
        if (descriptor.getKind() == -1) {
            if (this.getType().equals("com.apple.decmpfs")) {
                this._decmpfsHeader = new DecmpfsHeader(reader, this.getRecordLength());
            } else if (this.getType().equals("com.apple.system.Security")) {
                // empty if block
            }
        } else if (descriptor.getKind() != 0 || this.getType().equals("com.apple.decmpfs")) {
            // empty if block
        }
    }

    private String readType(GBinaryReader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this._typeLength; ++i) {
            reader.readNextByte();
            buffer.append((char)reader.readNextByte());
        }
        return buffer.toString();
    }

    public String getType() {
        return this.type;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public BTreeNodeDescriptor getDescriptor() {
        return this._descriptor;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public int getUnknown4() {
        return this.unknown4;
    }

    public int getUnknown5() {
        return this.unknown5;
    }

    public int getFileID() {
        return this.fileID;
    }

    public DecmpfsHeader getDecmpfsHeader() {
        return this._decmpfsHeader;
    }

    public long getRecordOffset() {
        return this._offset;
    }
}

