/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.event.ActionEvent;

public class DockingActionPerformer {
    private DockingActionPerformer() {
    }

    public static void perform(DockingActionIf action, ActionEvent event) {
        DockingActionPerformer.perform(action, event, DockingWindowManager.getActiveInstance());
    }

    public static void perform(DockingActionIf action, ActionEvent event, DockingWindowManager windowManager) {
        if (windowManager == null) {
            Msg.error(DockingActionPerformer.class, (Object)("No window manager found; unable to execute action: " + action.getFullName()));
        }
        DockingWindowManager.clearMouseOverHelp();
        ActionContext context = windowManager.createActionContext(action);
        context.setSourceObject(event.getSource());
        context.setEventClickModifiers(event.getModifiers());
        Swing.runLater(() -> {
            windowManager.setStatusText("");
            if (action.isValidContext(context) && action.isEnabledForContext(context)) {
                if (action instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                }
                action.actionPerformed(context);
            }
        });
    }
}

