/*
 * Decompiled with CFR 0.152.
 */
package docking.action.builder;

import docking.ActionContext;
import docking.action.builder.AbstractActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.Icon;

public class MultiStateActionBuilder<T>
extends AbstractActionBuilder<MultiStateDockingAction<T>, ActionContext, MultiStateActionBuilder<T>> {
    private BiConsumer<ActionState<T>, EventTrigger> actionStateChangedCallback;
    private boolean useCheckboxForIcons;
    private List<ActionState<T>> states = new ArrayList<ActionState<T>>();
    private Supplier<List<ActionState<T>>> generator = null;

    public MultiStateActionBuilder(String name, String owner) {
        super(name, owner);
    }

    @Override
    protected MultiStateActionBuilder<T> self() {
        return this;
    }

    public MultiStateActionBuilder<T> onActionStateChanged(BiConsumer<ActionState<T>, EventTrigger> biConsumer) {
        this.actionStateChangedCallback = biConsumer;
        return this.self();
    }

    public MultiStateActionBuilder<T> useCheckboxForIcons(boolean b) {
        this.useCheckboxForIcons = b;
        return this.self();
    }

    public MultiStateActionBuilder<T> addState(String displayName, Icon icon, T userData) {
        this.states.add(new ActionState<T>(displayName, icon, userData));
        return this.self();
    }

    public MultiStateActionBuilder<T> addState(ActionState<T> actionState) {
        this.states.add(actionState);
        return this.self();
    }

    public MultiStateActionBuilder<T> addStates(List<ActionState<T>> list) {
        this.states.addAll(list);
        return this.self();
    }

    public MultiStateActionBuilder<T> stateGenerator(Supplier<List<ActionState<T>>> generator) {
        this.generator = generator;
        return this.self();
    }

    @Override
    public MultiStateDockingAction<T> build() {
        this.validate();
        MultiStateDockingAction action = new MultiStateDockingAction<T>(this.name, this.owner){

            @Override
            public void actionStateChanged(ActionState<T> newActionState, EventTrigger trigger) {
                MultiStateActionBuilder.this.actionStateChangedCallback.accept(newActionState, trigger);
            }

            @Override
            public void actionPerformed(ActionContext context) {
                if (MultiStateActionBuilder.this.actionCallback != null) {
                    MultiStateActionBuilder.this.actionCallback.accept(context);
                } else {
                    super.actionPerformed(context);
                }
            }

            @Override
            protected List<ActionState<T>> getStates() {
                if (MultiStateActionBuilder.this.generator == null) {
                    return super.getStates();
                }
                return MultiStateActionBuilder.this.generator.get();
            }
        };
        for (ActionState<T> actionState : this.states) {
            action.addActionState(actionState);
        }
        this.decorateAction(action);
        action.setUseCheckboxForIcons(this.useCheckboxForIcons);
        return action;
    }

    @Override
    protected void validate() {
        if (this.actionStateChangedCallback == null) {
            throw new IllegalStateException("Can't build a MultiStateDockingAction without an action state changed callback");
        }
    }
}

