/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RangeColumnConstraint<T>
implements ColumnConstraint<T> {
    private static final Pattern RANGE_SPEC_PATTERN = Pattern.compile("\\[\\s*([^,\\]]+)\\s*,\\s*([^,\\]]+)\\s*\\]");
    protected final String name;
    private T minValue;
    private T maxValue;
    protected EditorProvider<T> editorProvider;
    private String group;

    protected RangeColumnConstraint(String name, T minValue, T maxValue, EditorProvider<T> editorProvider, String group) {
        this.name = name;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.editorProvider = editorProvider;
        this.group = group;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Class<T> getColumnType() {
        return this.getMinValue().getClass();
    }

    @Override
    public final ColumnConstraintEditor<T> getEditor(ColumnData<T> columnDataSource) {
        return this.editorProvider.getEditor(this, columnDataSource);
    }

    @Override
    public String getConstraintValueString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.editorProvider.toString(this.minValue));
        buf.append(",");
        buf.append(this.editorProvider.toString(this.maxValue));
        buf.append("]");
        return buf.toString();
    }

    @Override
    public ColumnConstraint<T> parseConstraintValue(String newValue, Object dataSource) {
        Matcher m = RANGE_SPEC_PATTERN.matcher(newValue);
        if (m.matches()) {
            String minStr = m.group(1);
            String maxStr = m.group(2);
            T newMinValue = this.editorProvider.parseValue(minStr.trim(), dataSource);
            T newMaxValue = this.editorProvider.parseValue(maxStr.trim(), dataSource);
            return this.copy(newMinValue, newMaxValue);
        }
        throw new IllegalArgumentException("Don't know how to parse '" + newValue + "'");
    }

    public abstract RangeColumnConstraint<T> copy(T var1, T var2);

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getMinValue(), this.getMaxValue());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        RangeColumnConstraint otherRangeConstraint = (RangeColumnConstraint)o;
        return this.getMinValue().equals(otherRangeConstraint.getMinValue()) && this.getMaxValue().equals(otherRangeConstraint.getMaxValue());
    }
}

