/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.DropTargetDragEventWrapper;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;

public class CascadedDropTarget
extends DropTarget {
    private DropTarget primaryDropTarget;
    private DropTarget secondaryDropTarget;
    private DropTarget activeDropTarget;

    public CascadedDropTarget(Component comp, DropTarget firstDropTarget, DropTarget secondDropTarget) {
        super(comp, null);
        if (firstDropTarget == null || secondDropTarget == null) {
            throw new NullPointerException("Drop targets may not be null");
        }
        this.primaryDropTarget = firstDropTarget;
        this.secondaryDropTarget = secondDropTarget;
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dtde) {
        this.clearAutoscroll();
        if (this.activeDropTarget == null) {
            dtde.rejectDrop();
            return;
        }
        this.activeDropTarget.drop(dtde);
    }

    @Override
    public synchronized void dragEnter(DropTargetDragEvent dtde) {
        this.initializeAutoscrolling(dtde.getLocation());
        DropTargetDragEventWrapper eventWrapper = new DropTargetDragEventWrapper(dtde);
        this.primaryDropTarget.dragEnter(eventWrapper);
        this.activeDropTarget = this.primaryDropTarget;
        if (!eventWrapper.isAccepted()) {
            this.activeDropTarget = this.secondaryDropTarget;
            this.secondaryDropTarget.dragEnter(eventWrapper);
        }
        if (!eventWrapper.isAccepted()) {
            this.activeDropTarget = null;
        }
        eventWrapper.flush();
    }

    @Override
    public synchronized void dragOver(DropTargetDragEvent dtde) {
        this.updateAutoscroll(dtde.getLocation());
        if (this.activeDropTarget == null) {
            DropTargetDragEventWrapper eventWrapper = new DropTargetDragEventWrapper(dtde);
            this.primaryDropTarget.dragOver(eventWrapper);
            this.activeDropTarget = this.primaryDropTarget;
            if (!eventWrapper.isAccepted()) {
                this.activeDropTarget = this.secondaryDropTarget;
                this.secondaryDropTarget.dragOver(eventWrapper);
            }
            if (!eventWrapper.isAccepted()) {
                this.activeDropTarget = null;
            }
            eventWrapper.flush();
        } else {
            this.activeDropTarget.dragOver(dtde);
        }
    }

    @Override
    public synchronized void dropActionChanged(DropTargetDragEvent dtde) {
        this.updateAutoscroll(dtde.getLocation());
        if (this.activeDropTarget != null) {
            this.activeDropTarget.dropActionChanged(dtde);
        }
    }

    @Override
    public synchronized void dragExit(DropTargetEvent dte) {
        this.clearAutoscroll();
        this.primaryDropTarget.dragExit(dte);
        this.secondaryDropTarget.dragExit(dte);
    }

    public DropTarget getPrimaryDropTarget() {
        return this.primaryDropTarget;
    }

    public DropTarget getSecondaryDropTarget() {
        return this.secondaryDropTarget;
    }

    public DropTarget removeDropTarget(DropTarget dropTarget) {
        CascadedDropTarget cascadedDropTarget;
        if (this.primaryDropTarget == dropTarget) {
            return this.secondaryDropTarget;
        }
        if (this.secondaryDropTarget == dropTarget) {
            return this.primaryDropTarget;
        }
        if (this.primaryDropTarget instanceof CascadedDropTarget) {
            cascadedDropTarget = (CascadedDropTarget)this.primaryDropTarget;
            this.primaryDropTarget = cascadedDropTarget.removeDropTarget(dropTarget);
        }
        if (this.secondaryDropTarget instanceof CascadedDropTarget) {
            cascadedDropTarget = (CascadedDropTarget)this.secondaryDropTarget;
            this.secondaryDropTarget = cascadedDropTarget.removeDropTarget(dropTarget);
        }
        return this;
    }
}

