/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.help.UnsupportedOperationException;

public class LazyCollection<T>
implements Collection<T> {
    private final Supplier<Stream<? extends T>> streamFactory;

    public LazyCollection(Supplier<Stream<? extends T>> streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public int size() {
        return (int)this.streamFactory.get().count();
    }

    @Override
    public boolean isEmpty() {
        return this.streamFactory.get().findAny().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.streamFactory.get().anyMatch(e -> Objects.equals(e, o));
    }

    @Override
    public Iterator<T> iterator() {
        return this.streamFactory.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.streamFactory.get().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.streamFactory.get().toList().toArray(a);
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet remains = new HashSet(c);
        return remains.isEmpty() || this.streamFactory.get().anyMatch(e -> {
            remains.remove(e);
            return remains.isEmpty();
        });
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

