/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.cmd.function.RemoveStackDepthChangeCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

class RemoveStackDepthChangeAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    RemoveStackDepthChangeAction(FunctionPlugin plugin) {
        super("Remove Stack Depth Change", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Remove Stack Depth Change"}, null, "Function"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Address address;
        Program program = context.getProgram();
        if (CallDepthChangeInfo.getStackDepthChange(program, address = context.getAddress()) == null) {
            return;
        }
        this.funcPlugin.execute(program, new RemoveStackDepthChangeCommand(address));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        return CallDepthChangeInfo.getStackDepthChange(context.getProgram(), context.getAddress()) != null;
    }
}

