/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import generic.theme.GIcon;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NextPreviousSameBytesAction
extends AbstractNextPreviousAction {
    private static final Icon ICON = new GIcon("icon.plugin.navigation.bytes");

    NextPreviousSameBytesAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Matching Byte Values", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ICON;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(86, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Same Bytes Value";
    }

    @Override
    protected String getInvertedNavigationTypeName() {
        return "Different Bytes Value";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getNextPreviousDifferentByteValueAddress(monitor, program, address, true);
        }
        return this.getNextPreviousAddress(monitor, program, address, true);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getNextPreviousDifferentByteValueAddress(monitor, program, address, false);
        }
        return this.getNextPreviousAddress(monitor, program, address, false);
    }

    private Address getNextPreviousDifferentByteValueAddress(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        byte value = 0;
        try {
            value = program.getMemory().getByte(address);
        }
        catch (MemoryAccessException e) {
            CodeUnit codeUnit = this.getNextPreviousCodeUnit(program, address, forward);
            return codeUnit == null ? null : codeUnit.getAddress();
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu != null) {
            address = forward ? cu.getMaxAddress() : cu.getMinAddress();
        }
        AddressSetView initialized = program.getMemory().getAllInitializedAddressSet();
        AddressIterator iterator = initialized.getAddresses(address, forward);
        iterator.next();
        Memory memory = program.getMemory();
        while (iterator.hasNext()) {
            monitor.checkCancelled();
            Address addr = (Address)iterator.next();
            try {
                byte testByte = memory.getByte(addr);
                if (testByte == value) continue;
                return addr;
            }
            catch (MemoryAccessException e) {
                throw new AssertException("Got MemoryAccessException when iterating over intialized memeory!");
            }
        }
        return null;
    }

    private Address getNextPreviousAddress(TaskMonitor monitor, Program program, Address address, boolean forward) {
        Address startAddress;
        byte[] bytes;
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu != null) {
            try {
                bytes = cu.getBytes();
            }
            catch (MemoryAccessException e) {
                Msg.debug((Object)((Object)this), (Object)("Exception getting code unit bytes at " + String.valueOf(cu.getAddress())), (Throwable)e);
                return null;
            }
            startAddress = forward ? cu.getMaxAddress().next() : cu.getMinAddress().previous();
        } else {
            try {
                Memory memory = program.getMemory();
                bytes = new byte[]{memory.getByte(address)};
            }
            catch (MemoryAccessException e) {
                Msg.debug((Object)((Object)this), (Object)("Exception getting code unit bytes at " + String.valueOf(address)), (Throwable)e);
                return null;
            }
            startAddress = forward ? address.next() : address.previous();
        }
        return this.getNextPreviousSameBytes(monitor, program, startAddress, bytes, forward);
    }

    private Address getNextPreviousSameBytes(TaskMonitor monitor, Program program, Address startAddress, byte[] bytes, boolean forward) {
        Memory memory = program.getMemory();
        byte[] mask = null;
        AddressSetView addresses = memory.getAllInitializedAddressSet();
        if (startAddress == null) {
            return null;
        }
        Address endAddress = forward ? addresses.getMaxAddress() : addresses.getMinAddress().previous();
        Address matchAddress = memory.findBytes(startAddress, endAddress, bytes, mask, forward, monitor);
        return matchAddress;
    }

    private CodeUnit getNextPreviousCodeUnit(Program program, Address address, boolean forward) {
        if (forward) {
            return program.getListing().getDefinedCodeUnitAfter(address);
        }
        return program.getListing().getDefinedCodeUnitBefore(address);
    }
}

