/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.util.CodeUnitInsertionException;

public class GenericRefernenceBaseRelocationFixupHandler
extends RelocationFixupHandler {
    @Override
    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        int size = program.getCompilerSpec().getDataOrganization().getPointerSize();
        if (size == 4) {
            return this.handleGenerically32(program, relocation, oldImageBase, newImageBase);
        }
        if (size == 8) {
            return this.handleGenerically64(program, relocation, oldImageBase, newImageBase);
        }
        return false;
    }

    @Override
    public boolean handlesProgram(Program program) {
        return false;
    }

    private boolean hasMatchingReference(Program program, Address address, Address candiateRelocationValue) {
        Reference[] referencesFrom;
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        for (Reference reference : referencesFrom = cu.getReferencesFrom()) {
            if (!reference.getToAddress().equals((Object)candiateRelocationValue)) continue;
            return true;
        }
        return false;
    }

    private boolean handleGenerically64(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        Memory memory;
        long value;
        long newValue;
        Address candiateRelocationValue;
        long diff = newImageBase.subtract(oldImageBase);
        Address address = relocation.getAddress();
        if (this.hasMatchingReference(program, address, candiateRelocationValue = newImageBase.getNewAddress(newValue = (value = (memory = program.getMemory()).getLong(address)) + diff))) {
            return this.process64BitRelocation(program, relocation, oldImageBase, newImageBase);
        }
        return false;
    }

    private boolean handleGenerically32(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        Memory memory;
        long value;
        int newValue;
        Address candiateRelocationValue;
        long diff = newImageBase.subtract(oldImageBase);
        Address address = relocation.getAddress();
        if (this.hasMatchingReference(program, address, candiateRelocationValue = newImageBase.getNewAddress((long)(newValue = (int)((value = (long)((memory = program.getMemory()).getInt(address) & 0xFFFFFFFF)) + diff))))) {
            return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
        }
        return false;
    }
}

