/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.AbstractSymbol;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.SymbolClass;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ImportedSymbol
extends AbstractSymbol {
    public static final int SIZEOF = 4;
    private int symbolClass;
    private int symbolNameOffset;
    private String _name;

    ImportedSymbol(BinaryReader reader, LoaderInfoHeader loader) throws IOException {
        int value = reader.readNextInt();
        this.symbolClass = (value & 0xFF000000) >> 24 & 0xFF;
        this.symbolNameOffset = value & 0xFFFFFF;
        long offset = loader.getSection().getContainerOffset() + loader.getLoaderStringsOffset() + this.symbolNameOffset;
        this._name = reader.readAsciiString(offset);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SymbolClass getSymbolClass() {
        return SymbolClass.get(this.symbolClass & 0xF);
    }

    public boolean isWeak() {
        return (this.symbolClass & 0x80) != 0;
    }

    public int getSymbolNameOffset() {
        return this.symbolNameOffset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return new TypedefDataType("ImportedSymbol", DWORD);
    }
}

